/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.messenger.redis;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.util.UUID;
import java.util.logging.Level;
import net.william278.papiproxybridge.PAPIProxyBridge;
import net.william278.papiproxybridge.config.Settings;
import net.william278.papiproxybridge.messenger.Messenger;
import net.william278.papiproxybridge.messenger.redis.RedisPubSubListener;
import net.william278.papiproxybridge.messenger.redis.StringByteArrayCodec;
import org.jetbrains.annotations.NotNull;

public class RedisMessenger
extends Messenger {
    private static final String CLIENT_NAME = "PAPIProxyBridge";
    private final PAPIProxyBridge plugin;
    private final boolean isRequest;
    private final Settings.RedisSettings redisSettings;
    private RedisClient client;
    private StatefulRedisConnection<String, byte[]> connection;
    private boolean closed = false;

    public RedisMessenger(@NotNull PAPIProxyBridge plugin, @NotNull Settings.RedisSettings redisSettings, boolean isRequest) {
        this.plugin = plugin;
        this.redisSettings = redisSettings;
        this.isRequest = isRequest;
    }

    @Override
    public void onEnable() {
        try {
            this.createClient();
        }
        catch (Throwable e) {
            this.plugin.log(Level.SEVERE, "Failed to establish connection with Redis. Please check the supplied credentials in the config file", e);
            return;
        }
        this.connection = this.client.connect((RedisCodec)StringByteArrayCodec.INSTANCE);
        this.listen();
    }

    private void createClient() {
        Settings.RedisSettings.RedisCredentials credentials = this.redisSettings.getCredentials();
        Settings.RedisSettings.RedisSentinel sentinel = this.redisSettings.getSentinel();
        if (sentinel.getNodes().isEmpty()) {
            this.client = RedisClient.create((RedisURI)RedisURI.builder().withHost(credentials.getHost()).withPort(credentials.getPort()).withPassword(credentials.getPassword() == null ? null : credentials.getPassword().toCharArray()).withClientName(CLIENT_NAME).withSsl(credentials.isUseSsl()).build());
            return;
        }
        this.plugin.log(Level.INFO, "Connecting with redis sentinel", new Throwable[0]);
        RedisURI.Builder builder = RedisURI.builder().withSentinelMasterId(sentinel.getMaster());
        sentinel.getNodes().forEach(node -> {
            String[] split = node.split(":");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid sentinel node: " + node);
            }
            builder.withSentinel(split[0], Integer.parseInt(split[1]));
        });
        builder.withClientName(CLIENT_NAME).withSsl(credentials.isUseSsl());
        this.client = RedisClient.create((RedisURI)builder.build());
    }

    @Override
    public void onDisable() {
        try {
            this.client.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.closed = true;
    }

    @Override
    public void sendMessage(@NotNull UUID uuid, @NotNull String channel, byte @NotNull [] message) {
        if (this.closed) {
            return;
        }
        this.connection.async().publish((Object)channel, (Object)message);
    }

    public void listen() {
        StatefulRedisPubSubConnection pubSubConnection = this.client.connectPubSub((RedisCodec)StringByteArrayCodec.INSTANCE);
        pubSubConnection.addListener((io.lettuce.core.pubsub.RedisPubSubListener)new RedisPubSubListener(){

            public void message(String string, byte[] bytes) {
                if (RedisMessenger.this.closed) {
                    return;
                }
                RedisMessenger.this.plugin.handleMessage(RedisMessenger.this.plugin, string, bytes, RedisMessenger.this.isRequest);
            }
        });
        pubSubConnection.async().subscribe((Object[])new String[]{PAPIProxyBridge.getChannel(this.isRequest), PAPIProxyBridge.getComponentChannel(this.isRequest)});
    }
}

