/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import net.william278.papiproxybridge.config.Settings;
import net.william278.papiproxybridge.libraries.configlib.configlib.YamlConfigurations;
import net.william278.papiproxybridge.messenger.Messenger;
import net.william278.papiproxybridge.user.OnlineUser;
import net.william278.papiproxybridge.user.Request;
import org.jetbrains.annotations.NotNull;

public interface PAPIProxyBridge {
    public static final String HANDSHAKE_PLACEHOLDER = "%papiproxybridge_handshake%";
    public static final String HANDSHAKE_RESPONSE = "confirmed";
    public static final String NAMESPACE = "papiproxybridge";
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String FORMAT_CHANNEL = "format";
    public static final String COMPONENT_CHANNEL = "component";

    @NotNull
    public static String getChannel(boolean isRequest) {
        return PAPIProxyBridge.getChannelNamespace() + ":" + PAPIProxyBridge.subChannel(isRequest);
    }

    @NotNull
    public static String getComponentChannel(boolean isRequest) {
        return PAPIProxyBridge.getChannelNamespace() + ":" + PAPIProxyBridge.subComponentChannel(isRequest);
    }

    public static String subChannel(boolean isRequest) {
        return PAPIProxyBridge.getChannelKey() + "-" + (isRequest ? REQUEST : RESPONSE);
    }

    public static String subComponentChannel(boolean isRequest) {
        return PAPIProxyBridge.getComponentChannelKey() + "-" + (isRequest ? REQUEST : RESPONSE);
    }

    @NotNull
    public static String getChannelNamespace() {
        return NAMESPACE;
    }

    @NotNull
    public static String getChannelKey() {
        return FORMAT_CHANNEL;
    }

    @NotNull
    public static String getComponentChannelKey() {
        return COMPONENT_CHANNEL;
    }

    default public String getLoadMessage() {
        return "PAPIProxyBridge (" + this.getServerType() + " " + this.getVersion() + ") has been enabled!";
    }

    public String getServerType();

    default public String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    @NotNull
    public Collection<? extends OnlineUser> getOnlineUsers();

    public Optional<? extends OnlineUser> findPlayer(@NotNull UUID var1);

    default public void handleMessage(@NotNull PAPIProxyBridge plugin, @NotNull String channel, byte[] message, boolean isRequest) {
        long leastSignificantBits;
        if (!channel.equals(PAPIProxyBridge.getChannel(isRequest)) && !channel.equals(PAPIProxyBridge.getComponentChannel(isRequest))) {
            return;
        }
        ByteArrayDataInput inputStream = ByteStreams.newDataInput((byte[])message);
        long mostSignificantBits = inputStream.readLong();
        UUID uuid = new UUID(mostSignificantBits, leastSignificantBits = inputStream.readLong());
        OnlineUser user = plugin.findPlayer(uuid).orElse(null);
        if (user == null) {
            return;
        }
        try {
            short messageLength = inputStream.readShort();
            byte[] messageBody = new byte[messageLength];
            inputStream.readFully(messageBody);
            user.handleMessage(plugin, Request.deserialize(messageBody), channel.equals(PAPIProxyBridge.getComponentChannel(isRequest)));
        }
        catch (IOException | ClassNotFoundException | IllegalStateException e) {
            plugin.log(Level.SEVERE, "Failed to fully read plugin message. Is PAPIProxyBridge up-to-date and installed on all servers?", e);
        }
    }

    public CompletableFuture<String> createRequest(@NotNull String var1, @NotNull OnlineUser var2, @NotNull UUID var3, boolean var4, long var5);

    @Deprecated(since="1.6", forRemoval=true)
    default public CompletableFuture<List<String>> findServers(long requestTimeout) {
        return this.getServers(requestTimeout).thenApply(ArrayList::new);
    }

    public CompletableFuture<Set<String>> getServers(long var1);

    public void log(@NotNull Level var1, @NotNull String var2, Throwable ... var3);

    public File getDataFolder();

    default public void loadConfig() {
        Path settingsFile = this.getDataFolder().toPath().resolve("settings.yml");
        Settings settings = YamlConfigurations.update(settingsFile, Settings.class);
        this.setSettings(settings);
    }

    public void setSettings(Settings var1);

    public void loadMessenger();

    public Messenger getMessenger();

    public Settings getSettings();
}

