/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core;

import java.util.ArrayList;
import java.util.List;
import net.william278.papiproxybridge.libraries.lettuce.core.AclCategory;
import net.william278.papiproxybridge.libraries.lettuce.core.CompositeArgument;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandKeyword;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandType;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.ProtocolKeyword;

public class AclSetuserArgs
implements CompositeArgument {
    private final List<Argument> arguments = new ArrayList<Argument>();

    public AclSetuserArgs on() {
        this.arguments.add(new Active(true));
        return this;
    }

    public AclSetuserArgs off() {
        this.arguments.add(new Active(false));
        return this;
    }

    public AclSetuserArgs keyPattern(String keyPattern) {
        this.arguments.add(new KeyPattern(keyPattern));
        return this;
    }

    public AclSetuserArgs allKeys() {
        this.arguments.add(new AllKeys());
        return this;
    }

    public AclSetuserArgs resetKeys() {
        this.arguments.add(new ResetKeys());
        return this;
    }

    public AclSetuserArgs channelPattern(String channelPattern) {
        this.arguments.add(new ChannelPattern(channelPattern));
        return this;
    }

    public AclSetuserArgs allChannels() {
        this.arguments.add(new AllChannels());
        return this;
    }

    public AclSetuserArgs resetChannels() {
        this.arguments.add(new ResetChannels());
        return this;
    }

    public AclSetuserArgs addCommand(CommandType command) {
        return this.addCommand(command, null);
    }

    public AclSetuserArgs addCommand(CommandType command, ProtocolKeyword subCommand) {
        this.arguments.add(new AddCommand(new CommandSubcommandPair(command, subCommand)));
        return this;
    }

    public AclSetuserArgs allCommands() {
        this.arguments.add(new AllCommands());
        return this;
    }

    public AclSetuserArgs removeCommand(CommandType command) {
        return this.removeCommand(command, null);
    }

    public AclSetuserArgs removeCommand(CommandType command, ProtocolKeyword subCommand) {
        this.arguments.add(new RemoveCommand(new CommandSubcommandPair(command, subCommand)));
        return this;
    }

    public AclSetuserArgs noCommands() {
        this.arguments.add(new NoCommands());
        return this;
    }

    public AclSetuserArgs addCategory(AclCategory category) {
        this.arguments.add(new AddCategory(category));
        return this;
    }

    public AclSetuserArgs removeCategory(AclCategory category) {
        this.arguments.add(new RemoveCategory(category));
        return this;
    }

    public AclSetuserArgs nopass() {
        this.arguments.add(new NoPass());
        return this;
    }

    public AclSetuserArgs resetpass() {
        this.arguments.add(new ResetPass());
        return this;
    }

    public AclSetuserArgs addPassword(String password) {
        this.arguments.add(new AddPassword(password));
        return this;
    }

    public AclSetuserArgs addHashedPassword(String hashedPassword) {
        this.arguments.add(new AddHashedPassword(hashedPassword));
        return this;
    }

    public AclSetuserArgs removePassword(String password) {
        this.arguments.add(new RemovePassword(password));
        return this;
    }

    public AclSetuserArgs removeHashedPassword(String hashedPassword) {
        this.arguments.add(new RemoveHashedPassword(hashedPassword));
        return this;
    }

    public AclSetuserArgs reset() {
        this.arguments.add(new Reset());
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        this.arguments.forEach(setuserArg -> setuserArg.build(args));
    }

    private static class RemoveHashedPassword
    extends StringArgument {
        RemoveHashedPassword(String password) {
            super("!" + password);
        }
    }

    private static class RemovePassword
    extends StringArgument {
        RemovePassword(String password) {
            super("<" + password);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class AddHashedPassword
    extends StringArgument {
        AddHashedPassword(String password) {
            super("#" + password);
        }
    }

    private static class AddPassword
    extends StringArgument {
        AddPassword(String password) {
            super(">" + password);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class ResetPass
    extends KeywordArgument {
        public ResetPass() {
            super(CommandKeyword.RESETPASS);
        }
    }

    private static class NoPass
    extends KeywordArgument {
        public NoPass() {
            super(CommandKeyword.NOPASS);
        }
    }

    private static class RemoveCategory
    extends StringArgument {
        RemoveCategory(AclCategory category) {
            super("-@" + category.name());
        }
    }

    private static class AddCategory
    extends StringArgument {
        AddCategory(AclCategory category) {
            super("+@" + category.name());
        }
    }

    private static class NoCommands
    extends KeywordArgument {
        public NoCommands() {
            super(CommandKeyword.NOCOMMANDS);
        }
    }

    private static class RemoveCommand
    implements Argument {
        private final CommandSubcommandPair command;

        RemoveCommand(CommandSubcommandPair command) {
            this.command = command;
        }

        @Override
        public <K, V> void build(CommandArgs<K, V> args) {
            if (this.command.getSubCommand() == null) {
                args.add("-" + this.command.getCommand().name());
            } else {
                args.add("-" + this.command.getCommand().name() + "|" + this.command.getSubCommand().toString());
            }
        }
    }

    private static class AddCommand
    implements Argument {
        private final CommandSubcommandPair command;

        AddCommand(CommandSubcommandPair command) {
            this.command = command;
        }

        @Override
        public <K, V> void build(CommandArgs<K, V> args) {
            if (this.command.getSubCommand() == null) {
                args.add("+" + this.command.getCommand().name());
            } else {
                args.add("+" + this.command.getCommand().name() + "|" + this.command.getSubCommand().toString());
            }
        }
    }

    private static class AllCommands
    extends KeywordArgument {
        public AllCommands() {
            super(CommandKeyword.ALLCOMMANDS);
        }
    }

    private static class ResetChannels
    extends KeywordArgument {
        public ResetChannels() {
            super(CommandKeyword.RESETCHANNELS);
        }
    }

    private static class AllChannels
    extends KeywordArgument {
        public AllChannels() {
            super(CommandKeyword.ALLCHANNELS);
        }
    }

    private static class ChannelPattern
    extends StringArgument {
        ChannelPattern(String channelPattern) {
            super("&" + channelPattern);
        }
    }

    private static class KeyPattern
    extends StringArgument {
        KeyPattern(String keyPattern) {
            super("~" + keyPattern);
        }
    }

    private static class ResetKeys
    extends KeywordArgument {
        public ResetKeys() {
            super(CommandKeyword.RESETKEYS);
        }
    }

    private static class AllKeys
    extends KeywordArgument {
        public AllKeys() {
            super(CommandKeyword.ALLKEYS);
        }
    }

    private static class Reset
    extends KeywordArgument {
        public Reset() {
            super(CommandKeyword.RESET);
        }
    }

    private static class Active
    extends KeywordArgument {
        Active(boolean active) {
            super(active ? CommandKeyword.ON : CommandKeyword.OFF);
        }
    }

    static class StringArgument
    implements Argument {
        private final String value;

        public StringArgument(String value) {
            this.value = value;
        }

        @Override
        public <K, V> void build(CommandArgs<K, V> args) {
            args.add(this.value);
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.value;
        }
    }

    static class KeywordArgument
    implements Argument {
        private final ProtocolKeyword value;

        public KeywordArgument(ProtocolKeyword value) {
            this.value = value;
        }

        @Override
        public <K, V> void build(CommandArgs<K, V> args) {
            args.add(this.value);
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.value.toString();
        }
    }

    private static interface Argument {
        public <K, V> void build(CommandArgs<K, V> var1);
    }

    private static class CommandSubcommandPair {
        private final CommandType command;
        private final ProtocolKeyword subCommand;

        private CommandSubcommandPair(CommandType command, ProtocolKeyword subCommand) {
            this.command = command;
            this.subCommand = subCommand;
        }

        public CommandType getCommand() {
            return this.command;
        }

        public ProtocolKeyword getSubCommand() {
            return this.subCommand;
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static AclSetuserArgs on() {
            return new AclSetuserArgs().on();
        }

        public static AclSetuserArgs off() {
            return new AclSetuserArgs().off();
        }

        public static AclSetuserArgs keyPattern(String keyPattern) {
            return new AclSetuserArgs().keyPattern(keyPattern);
        }

        public static AclSetuserArgs allKeys() {
            return new AclSetuserArgs().allKeys();
        }

        public static AclSetuserArgs resetKeys() {
            return new AclSetuserArgs().resetKeys();
        }

        public static AclSetuserArgs channelPattern(String channelPattern) {
            return new AclSetuserArgs().channelPattern(channelPattern);
        }

        public static AclSetuserArgs allChannels() {
            return new AclSetuserArgs().allChannels();
        }

        public static AclSetuserArgs resetChannels() {
            return new AclSetuserArgs().resetChannels();
        }

        public static AclSetuserArgs addCommand(CommandType command) {
            return new AclSetuserArgs().addCommand(command);
        }

        public static AclSetuserArgs addCommand(CommandType command, ProtocolKeyword subCommand) {
            return new AclSetuserArgs().addCommand(command, subCommand);
        }

        public static AclSetuserArgs allCommands() {
            return new AclSetuserArgs().allCommands();
        }

        public static AclSetuserArgs removeCommand(CommandType command) {
            return new AclSetuserArgs().removeCommand(command);
        }

        public static AclSetuserArgs removeCommand(CommandType command, ProtocolKeyword subCommand) {
            return new AclSetuserArgs().removeCommand(command, subCommand);
        }

        public static AclSetuserArgs noCommands() {
            return new AclSetuserArgs().noCommands();
        }

        public static AclSetuserArgs addCategory(AclCategory category) {
            return new AclSetuserArgs().addCategory(category);
        }

        public static AclSetuserArgs removeCategory(AclCategory category) {
            return new AclSetuserArgs().removeCategory(category);
        }

        public static AclSetuserArgs nopass() {
            return new AclSetuserArgs().nopass();
        }

        public static AclSetuserArgs resetpass() {
            return new AclSetuserArgs().resetpass();
        }

        public static AclSetuserArgs addPassword(String password) {
            return new AclSetuserArgs().addPassword(password);
        }

        public static AclSetuserArgs addHashedPassword(String hashedPassword) {
            return new AclSetuserArgs().addHashedPassword(hashedPassword);
        }

        public static AclSetuserArgs removePassword(String password) {
            return new AclSetuserArgs().removePassword(password);
        }

        public static AclSetuserArgs removeHashedPassword(String hashedPassword) {
            return new AclSetuserArgs().removeHashedPassword(hashedPassword);
        }

        public static AclSetuserArgs reset() {
            return new AclSetuserArgs().reset();
        }
    }
}

