/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import net.william278.papiproxybridge.libraries.lettuce.core.KeyValue;
import net.william278.papiproxybridge.libraries.lettuce.core.ScoredValue;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;

public class KeyValueOfScoredValueOutput<K, V>
extends CommandOutput<K, V, KeyValue<K, ScoredValue<V>>> {
    private K key;
    private V value;

    public KeyValueOfScoredValueOutput(RedisCodec<K, V> codec, K defaultKey) {
        super(codec, KeyValue.empty(defaultKey));
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes != null) {
            if (this.key == null) {
                this.key = this.codec.decodeKey(bytes);
                return;
            }
            if (this.value == null) {
                this.value = this.codec.decodeValue(bytes);
                return;
            }
            this.output = KeyValue.just(this.key, ScoredValue.just(Double.parseDouble(this.decodeString(bytes)), this.value));
        }
    }

    @Override
    public void set(double number) {
        if (this.key != null && this.value != null) {
            this.output = KeyValue.just(this.key, ScoredValue.just(number, this.value));
        }
    }
}

