/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.protocol;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import net.william278.papiproxybridge.libraries.lettuce.core.RedisCommandTimeoutException;
import net.william278.papiproxybridge.libraries.lettuce.core.RedisConnectionException;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.ExceptionFactory;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.ConnectionInitializer;
import net.william278.papiproxybridge.libraries.lettuce.core.resource.ClientResources;

public class RedisHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final ConnectionInitializer connectionInitializer;
    private final ClientResources clientResources;
    private final Duration initializeTimeout;
    private final CompletableFuture<Void> handshakeFuture = new CompletableFuture();
    private volatile boolean timedOut = false;

    public RedisHandshakeHandler(ConnectionInitializer connectionInitializer, ClientResources clientResources, Duration initializeTimeout) {
        this.connectionInitializer = connectionInitializer;
        this.clientResources = clientResources;
        this.initializeTimeout = initializeTimeout;
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        Runnable timeoutGuard = () -> {
            this.timedOut = true;
            if (this.handshakeFuture.isDone()) {
                return;
            }
            this.fail(ctx, new RedisCommandTimeoutException("Connection initialization timed out after " + ExceptionFactory.formatTimeout(this.initializeTimeout)));
        };
        Timeout timeoutHandle = this.clientResources.timer().newTimeout(t -> {
            if (this.clientResources.eventExecutorGroup().isShuttingDown()) {
                timeoutGuard.run();
                return;
            }
            this.clientResources.eventExecutorGroup().submit(timeoutGuard);
        }, this.initializeTimeout.toNanos(), TimeUnit.NANOSECONDS);
        this.handshakeFuture.thenAccept(ignore -> timeoutHandle.cancel());
        super.channelRegistered(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.shouldFail()) {
            this.fail(ctx, new RedisConnectionException("Connection closed prematurely"));
        }
        super.channelInactive(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        CompletionStage<Void> future = this.connectionInitializer.initialize(ctx.channel());
        future.whenComplete((ignore, throwable) -> {
            if (throwable != null) {
                if (this.shouldFail()) {
                    this.fail(ctx, (Throwable)throwable);
                }
            } else {
                ctx.fireChannelActive();
                this.succeed();
            }
        });
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.shouldFail()) {
            this.fail(ctx, cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    protected void succeed() {
        this.handshakeFuture.complete(null);
    }

    protected void fail(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)closeFuture -> this.handshakeFuture.completeExceptionally(cause)));
    }

    public CompletionStage<Void> channelInitialized() {
        return this.handshakeFuture;
    }

    private boolean shouldFail() {
        return !this.handshakeFuture.isDone() && !this.timedOut;
    }
}

