/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.resource;

import io.netty.channel.socket.SocketChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DefaultDnsCnameCache;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCnameCache;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceClassUtils;
import net.william278.papiproxybridge.libraries.lettuce.core.resource.Transports;

class AddressResolverGroupProvider {
    private static final InternalLogger logger;
    private static final AddressResolverGroup<?> ADDRESS_RESOLVER_GROUP;

    AddressResolverGroupProvider() {
    }

    static AddressResolverGroup<?> addressResolverGroup() {
        return ADDRESS_RESOLVER_GROUP;
    }

    static {
        DefaultAddressResolverGroup group;
        logger = InternalLoggerFactory.getInstance(AddressResolverGroupProvider.class);
        boolean dnsResolverAvailable = LettuceClassUtils.isPresent("io.netty.resolver.dns.DnsAddressResolverGroup");
        if (dnsResolverAvailable) {
            logger.debug("Starting with netty's non-blocking DNS resolver library");
            group = DefaultDnsAddressResolverGroupWrapper.INSTANCE;
        } else {
            logger.debug("Starting without optional netty's non-blocking DNS resolver library");
            group = DefaultAddressResolverGroup.INSTANCE;
        }
        ADDRESS_RESOLVER_GROUP = group;
    }

    private static class DefaultDnsAddressResolverGroupWrapper {
        static AddressResolverGroup<?> INSTANCE = new DnsAddressResolverGroup(new DnsNameResolverBuilder().channelType(Transports.datagramChannelClass()).socketChannelType(Transports.socketChannelClass().asSubclass(SocketChannel.class)).cnameCache((DnsCnameCache)new DefaultDnsCnameCache()).resolveCache((DnsCache)new DefaultDnsCache()));

        private DefaultDnsAddressResolverGroupWrapper() {
        }
    }
}

