/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.reactor.core.publisher;

import java.util.Objects;
import net.william278.papiproxybridge.libraries.reactivestreams.Publisher;
import net.william278.papiproxybridge.libraries.reactor.core.CorePublisher;
import net.william278.papiproxybridge.libraries.reactor.core.CoreSubscriber;
import net.william278.papiproxybridge.libraries.reactor.core.Fuseable;
import net.william278.papiproxybridge.libraries.reactor.core.Scannable;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.Mono;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.OptimizableOperator;
import net.william278.papiproxybridge.libraries.reactor.util.annotation.Nullable;

final class MonoSourceFuseable<I>
extends Mono<I>
implements Fuseable,
Scannable,
OptimizableOperator<I, I> {
    final Publisher<? extends I> source;
    @Nullable
    final OptimizableOperator<?, I> optimizableOperator;

    MonoSourceFuseable(Publisher<? extends I> source) {
        OptimizableOperator optimSource;
        this.source = Objects.requireNonNull(source);
        this.optimizableOperator = source instanceof OptimizableOperator ? (optimSource = (OptimizableOperator)source) : null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super I> actual) {
        this.source.subscribe(actual);
    }

    @Override
    public final CoreSubscriber<? super I> subscribeOrReturn(CoreSubscriber<? super I> actual) {
        return actual;
    }

    @Override
    public final CorePublisher<? extends I> source() {
        return this;
    }

    @Override
    public final OptimizableOperator<?, ? extends I> nextOptimizableSource() {
        return this.optimizableOperator;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.from(this.source).scanUnsafe(key);
        }
        return null;
    }
}

