/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.reactor.core.publisher;

import net.william278.papiproxybridge.libraries.reactor.core.CoreSubscriber;
import net.william278.papiproxybridge.libraries.reactor.core.Fuseable;
import net.william278.papiproxybridge.libraries.reactor.core.Scannable;
import net.william278.papiproxybridge.libraries.reactor.core.observability.SignalListener;
import net.william278.papiproxybridge.libraries.reactor.core.observability.SignalListenerFactory;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.ContextPropagation;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.ContextPropagationSupport;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.FluxTapFuseable;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.InternalMonoOperator;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.Mono;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.Operators;
import net.william278.papiproxybridge.libraries.reactor.util.annotation.Nullable;
import net.william278.papiproxybridge.libraries.reactor.util.context.Context;

final class MonoTapFuseable<T, STATE>
extends InternalMonoOperator<T, T>
implements Fuseable {
    final SignalListenerFactory<T, STATE> tapFactory;
    final STATE commonTapState;

    MonoTapFuseable(Mono<? extends T> source, SignalListenerFactory<T, STATE> tapFactory) {
        super(source);
        this.tapFactory = tapFactory;
        this.commonTapState = tapFactory.initializePublisherState(source);
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) throws Throwable {
        Context ctx;
        SignalListener<T> signalListener;
        try {
            signalListener = this.tapFactory.createListener(this.source, actual.currentContext().readOnly(), this.commonTapState);
        }
        catch (Throwable generatorError) {
            Operators.error(actual, generatorError);
            return null;
        }
        signalListener = ContextPropagationSupport.isContextPropagationAvailable() ? ContextPropagation.contextRestoreForTap(signalListener, actual::currentContext) : signalListener;
        try {
            signalListener.doFirst();
        }
        catch (Throwable listenerError) {
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return null;
        }
        try {
            ctx = signalListener.addToContext(actual.currentContext());
        }
        catch (Throwable e) {
            IllegalStateException listenerError = new IllegalStateException("Unable to augment tap Context at subscription via addToContext", e);
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return null;
        }
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            return new FluxTapFuseable.TapConditionalFuseableSubscriber<T>((Fuseable.ConditionalSubscriber)actual, signalListener, ctx);
        }
        return new FluxTapFuseable.TapFuseableSubscriber<T>(actual, signalListener, ctx);
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return -1;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

