/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.user;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import net.william278.papiproxybridge.PAPIProxyBridge;
import net.william278.papiproxybridge.user.Request;
import org.jetbrains.annotations.NotNull;

public interface OnlineUser {
    @NotNull
    public String getUsername();

    @NotNull
    public UUID getUniqueId();

    default public void sendMessage(@NotNull PAPIProxyBridge plugin, @NotNull Request request, boolean wantsJson, boolean isRequest) {
        ByteArrayDataOutput messageWriter = ByteStreams.newDataOutput();
        UUID uuid = this.getUniqueId();
        messageWriter.writeLong(uuid.getMostSignificantBits());
        messageWriter.writeLong(uuid.getLeastSignificantBits());
        try {
            byte[] serializedRequest = request.serialize();
            messageWriter.writeShort(serializedRequest.length);
            messageWriter.write(serializedRequest);
        }
        catch (IOException e) {
            plugin.log(Level.SEVERE, "Exception serializing request: " + String.valueOf(request), e);
            return;
        }
        plugin.getMessenger().sendMessage(request.getFormatFor(), wantsJson ? PAPIProxyBridge.getComponentChannel(isRequest) : PAPIProxyBridge.getChannel(isRequest), messageWriter.toByteArray());
    }

    public void handleMessage(@NotNull PAPIProxyBridge var1, @NotNull Request var2, boolean var3);

    default public boolean isConnected() {
        return true;
    }
}

