/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.user;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class Request {
    private static final short VERSION = 1;
    private final UUID uuid;
    private final UUID formatFor;
    private String message;

    public Request(@NotNull String message, @NotNull UUID formatFor) {
        this.uuid = UUID.randomUUID();
        this.formatFor = formatFor;
        this.message = message;
    }

    public String toString() {
        return this.uuid.toString() + this.formatFor.toString() + this.message;
    }

    public byte @NotNull [] serialize() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        dataStream.writeShort(1);
        dataStream.writeLong(this.uuid.getMostSignificantBits());
        dataStream.writeLong(this.uuid.getLeastSignificantBits());
        dataStream.writeLong(this.formatFor.getMostSignificantBits());
        dataStream.writeLong(this.formatFor.getLeastSignificantBits());
        dataStream.writeUTF(this.message);
        return byteStream.toByteArray();
    }

    @NotNull
    public static Request deserialize(byte @NotNull [] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
        DataInputStream dataStream = new DataInputStream(byteStream);
        short version = dataStream.readShort();
        if (version != 1) {
            throw new IllegalStateException("Invalid version: " + version + ". Make sure you are using the latest version of PapiProxyBridge on all servers.");
        }
        UUID uuid = new UUID(dataStream.readLong(), dataStream.readLong());
        UUID formatFor = new UUID(dataStream.readLong(), dataStream.readLong());
        String message = dataStream.readUTF();
        return new Request(uuid, formatFor, message);
    }

    @Generated
    public Request(UUID uuid, UUID formatFor, String message) {
        this.uuid = uuid;
        this.formatFor = formatFor;
        this.message = message;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public UUID getFormatFor() {
        return this.formatFor;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }
}

