/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import lombok.Generated;
import net.william278.papiproxybridge.ProxyPAPIProxyBridge;
import net.william278.papiproxybridge.api.PlaceholderAPI;
import net.william278.papiproxybridge.config.Settings;
import net.william278.papiproxybridge.libraries.bstats.charts.SimplePie;
import net.william278.papiproxybridge.libraries.bstats.velocity.Metrics;
import net.william278.papiproxybridge.messenger.Messenger;
import net.william278.papiproxybridge.messenger.PluginMessageMessenger;
import net.william278.papiproxybridge.messenger.redis.RedisMessenger;
import net.william278.papiproxybridge.user.VelocityUser;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Plugin(id="papiproxybridge")
public class VelocityPAPIProxyBridge
implements ProxyPAPIProxyBridge {
    private final ConcurrentMap<UUID, CompletableFuture<String>> requests;
    private final ProxyServer server;
    private final Logger logger;
    private final Metrics.Factory metricsFactory;
    private final Path configDirectory;
    private final Map<UUID, VelocityUser> velocityUsers;
    private Settings settings;
    private Messenger messenger;

    @Inject
    public VelocityPAPIProxyBridge(ProxyServer server, Logger logger, Metrics.Factory metricsFactory, @DataDirectory Path configDirectory) {
        this.server = server;
        this.logger = logger;
        this.metricsFactory = metricsFactory;
        this.configDirectory = configDirectory;
        this.requests = Maps.newConcurrentMap();
        this.velocityUsers = Maps.newConcurrentMap();
    }

    private void loadOnlineUsers() {
        this.velocityUsers.clear();
        this.server.getAllPlayers().forEach(this::loadPlayer);
    }

    private void loadPlayer(@NotNull Player player) {
        VelocityUser user = VelocityUser.adapt(player);
        this.velocityUsers.put(player.getUniqueId(), user);
    }

    @Subscribe
    public void onProxyInitialization(@NotNull ProxyInitializeEvent event) {
        this.loadConfig();
        this.loadMessenger();
        this.messenger.onEnable();
        this.loadOnlineUsers();
        PlaceholderAPI.register(this);
        this.setupMetrics();
        this.logger.info(this.getLoadMessage());
    }

    @Subscribe
    public void onProxyShutdown(@NotNull ProxyShutdownEvent event) {
        this.messenger.onDisable();
    }

    @Subscribe
    public void onConnect(PostLoginEvent event) {
        this.loadPlayer(event.getPlayer());
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent event) {
        if (event.getLoginStatus() == DisconnectEvent.LoginStatus.CONFLICTING_LOGIN) {
            return;
        }
        this.velocityUsers.remove(event.getPlayer().getUniqueId());
        PlaceholderAPI.clearCache(event.getPlayer().getUniqueId());
    }

    private void setupMetrics() {
        Metrics metrics = this.metricsFactory.make(this, 17878);
        metrics.addCustomChart(new SimplePie("messengerType", () -> this.getSettings().getMessenger().name()));
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        if (exceptions.length > 0) {
            this.logger.info("Error: {}", (Object)message);
            this.logger.error(message, exceptions[0]);
        } else if (level.equals(Level.SEVERE)) {
            this.logger.error(message);
        } else if (level.equals(Level.WARNING)) {
            this.logger.warn(message);
        } else {
            this.logger.info(message);
        }
    }

    @Override
    public File getDataFolder() {
        return this.configDirectory.toFile();
    }

    @Override
    @NotNull
    public ConcurrentMap<UUID, CompletableFuture<String>> getRequests() {
        return this.requests;
    }

    @Override
    public String getServerType() {
        return "Velocity";
    }

    @NotNull
    public Collection<VelocityUser> getOnlineUsers() {
        return this.velocityUsers.values();
    }

    public Optional<VelocityUser> findPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(this.velocityUsers.get(uuid));
    }

    public VelocityUser getPlayer(@NotNull Player player) {
        return this.velocityUsers.get(player.getUniqueId());
    }

    @Override
    public void loadMessenger() {
        switch (this.settings.getMessenger()) {
            case REDIS: {
                this.messenger = new RedisMessenger(this, this.settings.getRedis(), false);
                break;
            }
            case PLUGIN_MESSAGE: {
                this.messenger = new PluginMessageMessenger(this);
            }
        }
        this.log(Level.INFO, "Loaded messenger " + this.getSettings().getMessenger().name(), new Throwable[0]);
    }

    @Generated
    public ProxyServer getServer() {
        return this.server;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    @Generated
    public Path getConfigDirectory() {
        return this.configDirectory;
    }

    @Generated
    public Map<UUID, VelocityUser> getVelocityUsers() {
        return this.velocityUsers;
    }

    @Override
    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    @Generated
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Override
    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

