/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;

public class MapOutput<K, V>
extends CommandOutput<K, V, Map<K, V>> {
    private boolean initialized;
    private K key;
    private boolean hasKey;

    public MapOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyMap());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (!this.hasKey) {
            this.key = bytes == null ? null : this.codec.decodeKey(bytes);
            this.hasKey = true;
            return;
        }
        Object value = bytes == null ? null : (Object)this.codec.decodeValue(bytes);
        ((Map)this.output).put(this.key, value);
        this.key = null;
        this.hasKey = false;
    }

    @Override
    public void set(long integer) {
        if (!this.hasKey) {
            this.key = integer;
            this.hasKey = true;
            return;
        }
        Long value = integer;
        ((Map)this.output).put(this.key, value);
        this.key = null;
        this.hasKey = false;
    }

    @Override
    public void set(double number) {
        if (!this.hasKey) {
            this.key = number;
            this.hasKey = true;
            return;
        }
        Double value = number;
        ((Map)this.output).put(this.key, value);
        this.key = null;
        this.hasKey = false;
    }

    @Override
    public void set(boolean flag) {
        if (!this.hasKey) {
            this.key = flag;
            this.hasKey = true;
            return;
        }
        Boolean value = flag;
        ((Map)this.output).put(this.key, value);
        this.key = null;
        this.hasKey = false;
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = new LinkedHashMap(count / 2, 1.0f);
            this.initialized = true;
        }
    }
}

