/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.messenger;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.LegacyChannelIdentifier;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import lombok.Generated;
import net.william278.papiproxybridge.PAPIProxyBridge;
import net.william278.papiproxybridge.VelocityPAPIProxyBridge;
import net.william278.papiproxybridge.messenger.Messenger;
import net.william278.papiproxybridge.user.VelocityUser;
import org.jetbrains.annotations.NotNull;

public class PluginMessageMessenger
extends Messenger {
    private final VelocityPAPIProxyBridge plugin;
    private ChannelIdentifier responseChannelIdentifier;
    private ChannelIdentifier responseComponentChannelIdentifier;

    @Override
    public void onEnable() {
        this.responseChannelIdentifier = new LegacyChannelIdentifier(PAPIProxyBridge.getChannel(false));
        this.responseComponentChannelIdentifier = new LegacyChannelIdentifier(PAPIProxyBridge.getComponentChannel(false));
        this.plugin.getServer().getChannelRegistrar().register(new ChannelIdentifier[]{this.responseChannelIdentifier});
        this.plugin.getServer().getChannelRegistrar().register(new ChannelIdentifier[]{this.responseComponentChannelIdentifier});
        this.plugin.getServer().getEventManager().register((Object)this.plugin, (Object)this);
    }

    @Override
    public void sendMessage(@NotNull UUID uuid, @NotNull String channel, byte @NotNull [] message) {
        Optional<VelocityUser> optionalVelocityUser = this.plugin.findPlayer(uuid);
        if (optionalVelocityUser.isEmpty()) {
            return;
        }
        VelocityUser user = optionalVelocityUser.get();
        Player player = user.player();
        player.getCurrentServer().ifPresent(server -> {
            if (!server.sendPluginMessage((ChannelIdentifier)new LegacyChannelIdentifier(channel), message)) {
                this.plugin.log(Level.SEVERE, "Failed to send plugin message to " + server.getServerInfo().getName() + " for player " + player.getUsername() + " on channel " + channel, new Throwable[0]);
            }
        });
    }

    @Subscribe
    public void onPluginMessageReceived(@NotNull PluginMessageEvent event) {
        ChannelIdentifier channelId = event.getIdentifier();
        if (!channelId.equals((Object)this.responseChannelIdentifier) && !channelId.equals((Object)this.responseComponentChannelIdentifier)) {
            return;
        }
        this.plugin.handleMessage(this.plugin, event.getIdentifier().getId(), event.getData(), false);
        event.setResult(PluginMessageEvent.ForwardResult.handled());
    }

    @Override
    public void onDisable() {
        this.plugin.getServer().getChannelRegistrar().unregister(new ChannelIdentifier[]{this.responseChannelIdentifier});
        this.plugin.getServer().getChannelRegistrar().unregister(new ChannelIdentifier[]{this.responseComponentChannelIdentifier});
        this.plugin.getServer().getEventManager().unregisterListener((Object)this.plugin, (Object)this);
    }

    @Generated
    public PluginMessageMessenger(VelocityPAPIProxyBridge plugin) {
        this.plugin = plugin;
    }
}

