/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.messenger.redis;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;

public class StringByteArrayCodec
implements RedisCodec<String, byte[]> {
    public static final StringByteArrayCodec INSTANCE = new StringByteArrayCodec();
    private static final byte[] EMPTY = new byte[0];
    private final Charset charset = StandardCharsets.UTF_8;

    @Override
    public String decodeKey(ByteBuffer bytes) {
        return this.charset.decode(bytes).toString();
    }

    @Override
    public byte[] decodeValue(ByteBuffer bytes) {
        return StringByteArrayCodec.getBytes(bytes);
    }

    @Override
    public ByteBuffer encodeKey(String key) {
        return this.charset.encode(key);
    }

    @Override
    public ByteBuffer encodeValue(byte[] value) {
        if (value == null) {
            return ByteBuffer.wrap(EMPTY);
        }
        return ByteBuffer.wrap(value);
    }

    private static byte[] getBytes(ByteBuffer buffer) {
        byte[] b = new byte[buffer.remaining()];
        buffer.get(b);
        return b;
    }
}

