/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TrackingInfo {
    private final Set<TrackingFlag> flags = new HashSet<TrackingFlag>();
    private final long redirect;
    private final List<String> prefixes = new ArrayList<String>();

    public TrackingInfo(Set<TrackingFlag> flags, long redirect, List<String> prefixes) {
        this.flags.addAll(flags);
        this.redirect = redirect;
        this.prefixes.addAll(prefixes);
    }

    public Set<TrackingFlag> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    public long getRedirect() {
        return this.redirect;
    }

    public List<String> getPrefixes() {
        return Collections.unmodifiableList(this.prefixes);
    }

    public String toString() {
        return "TrackingInfo{flags=" + this.flags + ", redirect=" + this.redirect + ", prefixes=" + this.prefixes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackingInfo that = (TrackingInfo)o;
        return this.redirect == that.redirect && Objects.equals(this.flags, that.flags) && Objects.equals(this.prefixes, that.prefixes);
    }

    public int hashCode() {
        return Objects.hash(this.flags, this.redirect, this.prefixes);
    }

    public static enum TrackingFlag {
        OFF,
        ON,
        BCAST,
        OPTIN,
        OPTOUT,
        CACHING_YES,
        CACHING_NO,
        NOLOOP,
        BROKEN_REDIRECT;


        public static TrackingFlag from(String flag) {
            switch (flag.toLowerCase()) {
                case "off": {
                    return OFF;
                }
                case "on": {
                    return ON;
                }
                case "bcast": {
                    return BCAST;
                }
                case "optin": {
                    return OPTIN;
                }
                case "optout": {
                    return OPTOUT;
                }
                case "caching-yes": {
                    return CACHING_YES;
                }
                case "caching-no": {
                    return CACHING_NO;
                }
                case "noloop": {
                    return NOLOOP;
                }
                case "broken_redirect": {
                    return BROKEN_REDIRECT;
                }
            }
            throw new RuntimeException("Unsupported flag: " + flag);
        }
    }
}

