/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.event.command;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.william278.papiproxybridge.libraries.lettuce.core.event.command.CommandBaseEvent;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.RedisCommand;

public class CommandSucceededEvent
extends CommandBaseEvent {
    private final long started;
    private final long completed;

    public CommandSucceededEvent(RedisCommand<Object, Object, Object> command, Map<String, Object> context, long started, long completed) {
        super(command, context);
        this.started = started;
        this.completed = completed;
    }

    public Duration getDuration() {
        return Duration.ofMillis(this.completed - this.started);
    }

    public long getDuration(TimeUnit unit) {
        return unit.convert(this.completed - this.started, TimeUnit.MILLISECONDS);
    }

    public Instant getStarted() {
        return Instant.ofEpochMilli(this.started);
    }

    public Instant getCompleted() {
        return Instant.ofEpochMilli(this.completed);
    }
}

