/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.StringCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceFactories;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.OutputFactory;

public class ObjectOutput<K, V>
extends CommandOutput<K, V, Object> {
    private final Deque<Object> stack = LettuceFactories.newSpScQueue();
    private Object current;
    private boolean hasCurrent = false;
    private int depth = 0;
    private boolean initialized;

    public ObjectOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
    }

    @Override
    public void set(long integer) {
        if (!this.initialized) {
            this.output = new ArrayList();
        }
        this.setValue(integer);
    }

    @Override
    public void set(double number) {
        this.setValue(number);
    }

    @Override
    public void setBigNumber(ByteBuffer bytes) {
        this.setSingle(bytes);
    }

    @Override
    public void set(boolean value) {
        this.setValue(value);
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.setValue(bytes == null ? null : this.codec.decodeValue(bytes));
    }

    @Override
    public void setSingle(ByteBuffer bytes) {
        this.setValue(bytes == null ? null : StringCodec.UTF8.decodeValue(bytes));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValue(Object value) {
        if (this.output != null) {
            if (this.output instanceof Collection) {
                ((Collection)this.output).add(value);
                return;
            } else {
                if (!(this.output instanceof Map)) throw new IllegalStateException(String.format("Output %s is not a supported container type to append a response value", this.output));
                if (!this.hasCurrent) {
                    this.current = value;
                    this.hasCurrent = true;
                    return;
                } else {
                    ((Map)this.output).put(this.current, value);
                    this.current = null;
                    this.hasCurrent = false;
                }
            }
            return;
        } else {
            this.output = value;
        }
    }

    @Override
    public void complete(int depth) {
        if (depth > 0 && depth < this.depth) {
            this.stack.pop();
            this.output = this.stack.peek();
            --this.depth;
        }
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(Math.max(1, count));
            this.push(this.output);
            this.initialized = true;
        } else {
            List list = OutputFactory.newList(count);
            this.setValue(list);
            this.push(list);
            this.output = list;
        }
        ++this.depth;
    }

    @Override
    public void multiMap(int count) {
        if (!this.initialized) {
            this.output = new LinkedHashMap(count);
            this.initialized = true;
            this.push(this.output);
        } else {
            LinkedHashMap map = new LinkedHashMap(count);
            this.setValue(map);
            this.push(map);
            this.output = map;
        }
        ++this.depth;
    }

    private void push(Object output) {
        this.stack.push(output);
    }
}

