/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import net.william278.papiproxybridge.libraries.lettuce.core.ScoredValue;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceStrings;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;

public class ScoredValueOutput<K, V>
extends CommandOutput<K, V, ScoredValue<V>> {
    private V value;
    private boolean hasValue;

    public ScoredValueOutput(RedisCodec<K, V> codec) {
        super(codec, ScoredValue.empty());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null) {
            return;
        }
        if (!this.hasValue) {
            this.value = this.codec.decodeValue(bytes);
            this.hasValue = true;
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeString(bytes));
        this.set(score);
    }

    @Override
    public void set(long integer) {
        this.value = integer;
    }

    @Override
    public void set(double number) {
        this.output = ScoredValue.just(number, this.value);
        this.value = null;
        this.hasValue = false;
    }
}

