/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.protocol;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import net.william278.papiproxybridge.libraries.lettuce.core.ClientOptions;
import net.william278.papiproxybridge.libraries.lettuce.core.RedisCommandTimeoutException;
import net.william278.papiproxybridge.libraries.lettuce.core.SslConnectionBuilder;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceAssert;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceSets;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.ChannelLogDescriptor;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.ConnectionFacade;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.RedisHandshakeHandler;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.Mono;
import net.william278.papiproxybridge.libraries.reactor.util.function.Tuple2;
import net.william278.papiproxybridge.libraries.reactor.util.function.Tuples;

class ReconnectionHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReconnectionHandler.class);
    private static final Set<Class<?>> EXECUTION_EXCEPTION_TYPES = LettuceSets.unmodifiableSet(TimeoutException.class, CancellationException.class, RedisCommandTimeoutException.class, ConnectException.class);
    private final ClientOptions clientOptions;
    private final Bootstrap bootstrap;
    private final Mono<SocketAddress> socketAddressSupplier;
    private final ConnectionFacade connectionFacade;
    private volatile CompletableFuture<Channel> currentFuture;
    private volatile boolean reconnectSuspended;

    ReconnectionHandler(ClientOptions clientOptions, Bootstrap bootstrap, Mono<SocketAddress> socketAddressSupplier, Timer timer, ExecutorService reconnectWorkers, ConnectionFacade connectionFacade) {
        LettuceAssert.notNull(socketAddressSupplier, "SocketAddressSupplier must not be null");
        LettuceAssert.notNull((Object)bootstrap, "Bootstrap must not be null");
        LettuceAssert.notNull((Object)timer, "Timer must not be null");
        LettuceAssert.notNull((Object)reconnectWorkers, "ExecutorService must not be null");
        LettuceAssert.notNull((Object)connectionFacade, "ConnectionFacade must not be null");
        this.socketAddressSupplier = socketAddressSupplier;
        this.bootstrap = bootstrap;
        this.clientOptions = clientOptions;
        this.connectionFacade = connectionFacade;
    }

    protected Tuple2<CompletableFuture<Channel>, CompletableFuture<SocketAddress>> reconnect() {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture address = new CompletableFuture();
        this.socketAddressSupplier.subscribe(remoteAddress -> {
            address.complete(remoteAddress);
            if (future.isCancelled()) {
                return;
            }
            this.reconnect0(future, (SocketAddress)remoteAddress);
        }, ex -> {
            if (!address.isDone()) {
                address.completeExceptionally((Throwable)ex);
            }
            future.completeExceptionally((Throwable)ex);
        });
        this.currentFuture = future;
        return Tuples.of(future, address);
    }

    private void reconnect0(CompletableFuture<Channel> result, SocketAddress remoteAddress) {
        ChannelHandler handler = this.bootstrap.config().handler();
        if (SslConnectionBuilder.isSslChannelInitializer(handler)) {
            this.bootstrap.handler(SslConnectionBuilder.withSocketAddress(handler, remoteAddress));
        }
        ChannelFuture connectFuture = this.bootstrap.connect(remoteAddress);
        logger.debug("Reconnecting to Redis at {}", (Object)remoteAddress);
        result.whenComplete((c, t) -> {
            if (t instanceof CancellationException) {
                connectFuture.cancel(true);
            }
        });
        connectFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (!future.isSuccess()) {
                result.completeExceptionally(future.cause());
                return;
            }
            RedisHandshakeHandler handshakeHandler = connectFuture.channel().pipeline().get(RedisHandshakeHandler.class);
            if (handshakeHandler == null) {
                result.completeExceptionally(new IllegalStateException("RedisHandshakeHandler not registered"));
                return;
            }
            handshakeHandler.channelInitialized().whenComplete((success, throwable) -> {
                if (throwable != null) {
                    if (ReconnectionHandler.isExecutionException(throwable)) {
                        result.completeExceptionally((Throwable)throwable);
                        return;
                    }
                    if (this.clientOptions.isCancelCommandsOnReconnectFailure()) {
                        this.connectionFacade.reset();
                    }
                    if (this.clientOptions.isSuspendReconnectOnProtocolFailure()) {
                        logger.error("Disabling autoReconnect due to initialization failure", (Throwable)throwable);
                        this.setReconnectSuspended(true);
                    }
                    result.completeExceptionally((Throwable)throwable);
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.info("Reconnected to {}, Channel {}", (Object)remoteAddress, (Object)ChannelLogDescriptor.logDescriptor(connectFuture.channel()));
                } else {
                    logger.info("Reconnected to {}", (Object)remoteAddress);
                }
                result.complete(connectFuture.channel());
            });
        }));
    }

    boolean isReconnectSuspended() {
        return this.reconnectSuspended;
    }

    void setReconnectSuspended(boolean reconnectSuspended) {
        this.reconnectSuspended = reconnectSuspended;
    }

    void prepareClose() {
        CompletableFuture<Channel> currentFuture = this.currentFuture;
        if (currentFuture != null && !currentFuture.isDone()) {
            currentFuture.cancel(true);
        }
    }

    public static boolean isExecutionException(Throwable throwable) {
        for (Class<?> type : EXECUTION_EXCEPTION_TYPES) {
            if (!type.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }

    ClientOptions getClientOptions() {
        return this.clientOptions;
    }
}

