/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.resource;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceAssert;
import net.william278.papiproxybridge.libraries.lettuce.core.resource.ConstantDelay;
import net.william278.papiproxybridge.libraries.lettuce.core.resource.DecorrelatedJitterDelay;
import net.william278.papiproxybridge.libraries.lettuce.core.resource.EqualJitterDelay;
import net.william278.papiproxybridge.libraries.lettuce.core.resource.ExponentialDelay;
import net.william278.papiproxybridge.libraries.lettuce.core.resource.FullJitterDelay;

public abstract class Delay {
    private static Duration DEFAULT_LOWER_BOUND = Duration.ZERO;
    private static Duration DEFAULT_UPPER_BOUND = Duration.ofSeconds(30L);
    private static int DEFAULT_POWER_OF = 2;
    private static TimeUnit DEFAULT_TIMEUNIT = TimeUnit.MILLISECONDS;

    protected Delay() {
    }

    public abstract Duration createDelay(long var1);

    public static Delay constant(Duration delay) {
        LettuceAssert.notNull((Object)delay, "Delay must not be null");
        LettuceAssert.isTrue(delay.toNanos() >= 0L, "Delay must be greater or equal to 0");
        return new ConstantDelay(delay);
    }

    @Deprecated
    public static Delay constant(int delay, TimeUnit timeUnit) {
        LettuceAssert.notNull((Object)timeUnit, "TimeUnit must not be null");
        return Delay.constant(Duration.ofNanos(timeUnit.toNanos(delay)));
    }

    public static Delay exponential() {
        return Delay.exponential(DEFAULT_LOWER_BOUND, DEFAULT_UPPER_BOUND, DEFAULT_POWER_OF, DEFAULT_TIMEUNIT);
    }

    public static Delay exponential(Duration lower, Duration upper, int powersOf, TimeUnit targetTimeUnit) {
        LettuceAssert.notNull((Object)lower, "Lower boundary must not be null");
        LettuceAssert.isTrue(lower.toNanos() >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.notNull((Object)upper, "Upper boundary must not be null");
        LettuceAssert.isTrue(upper.toNanos() > lower.toNanos(), "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(powersOf > 1, "PowersOf must be greater than 1");
        LettuceAssert.notNull((Object)targetTimeUnit, "Target TimeUnit must not be null");
        return new ExponentialDelay(lower, upper, powersOf, targetTimeUnit);
    }

    public static Delay exponential(long lower, long upper, TimeUnit unit, int powersOf) {
        LettuceAssert.isTrue(lower >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.isTrue(upper > lower, "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(powersOf > 1, "PowersOf must be greater than 1");
        LettuceAssert.notNull((Object)unit, "TimeUnit must not be null");
        return Delay.exponential(Duration.ofNanos(unit.toNanos(lower)), Duration.ofNanos(unit.toNanos(upper)), powersOf, unit);
    }

    public static Delay equalJitter() {
        return Delay.equalJitter(DEFAULT_LOWER_BOUND, DEFAULT_UPPER_BOUND, 1L, DEFAULT_TIMEUNIT);
    }

    public static Delay equalJitter(Duration lower, Duration upper, long base, TimeUnit targetTimeUnit) {
        LettuceAssert.notNull((Object)lower, "Lower boundary must not be null");
        LettuceAssert.isTrue(lower.toNanos() >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.notNull((Object)upper, "Upper boundary must not be null");
        LettuceAssert.isTrue(upper.toNanos() > lower.toNanos(), "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(base >= 1L, "Base must be greater or equal to 1");
        LettuceAssert.notNull((Object)targetTimeUnit, "Target TimeUnit must not be null");
        return new EqualJitterDelay(lower, upper, base, targetTimeUnit);
    }

    public static Delay equalJitter(long lower, long upper, long base, TimeUnit unit) {
        LettuceAssert.isTrue(lower >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.isTrue(upper > lower, "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(base >= 1L, "Base must be greater or equal to 1");
        LettuceAssert.notNull((Object)unit, "TimeUnit must not be null");
        return Delay.equalJitter(Duration.ofNanos(unit.toNanos(lower)), Duration.ofNanos(unit.toNanos(upper)), base, unit);
    }

    public static Delay fullJitter() {
        return Delay.fullJitter(DEFAULT_LOWER_BOUND, DEFAULT_UPPER_BOUND, 1L, DEFAULT_TIMEUNIT);
    }

    public static Delay fullJitter(Duration lower, Duration upper, long base, TimeUnit targetTimeUnit) {
        LettuceAssert.notNull((Object)lower, "Lower boundary must not be null");
        LettuceAssert.isTrue(lower.toNanos() >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.notNull((Object)upper, "Upper boundary must not be null");
        LettuceAssert.isTrue(upper.toNanos() > lower.toNanos(), "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(base >= 1L, "Base must be greater or equal to 1");
        LettuceAssert.notNull((Object)targetTimeUnit, "Target TimeUnit must not be null");
        return new FullJitterDelay(lower, upper, base, targetTimeUnit);
    }

    public static Delay fullJitter(long lower, long upper, long base, TimeUnit unit) {
        LettuceAssert.isTrue(lower >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.isTrue(upper > lower, "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(base >= 1L, "Base must be greater or equal to 1");
        LettuceAssert.notNull((Object)unit, "TimeUnit must not be null");
        return Delay.fullJitter(Duration.ofNanos(unit.toNanos(lower)), Duration.ofNanos(unit.toNanos(upper)), base, unit);
    }

    public static Supplier<Delay> decorrelatedJitter() {
        return Delay.decorrelatedJitter(DEFAULT_LOWER_BOUND, DEFAULT_UPPER_BOUND, 0L, DEFAULT_TIMEUNIT);
    }

    public static Supplier<Delay> decorrelatedJitter(Duration lower, Duration upper, long base, TimeUnit targetTimeUnit) {
        LettuceAssert.notNull((Object)lower, "Lower boundary must not be null");
        LettuceAssert.isTrue(lower.toNanos() >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.notNull((Object)upper, "Upper boundary must not be null");
        LettuceAssert.isTrue(upper.toNanos() > lower.toNanos(), "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(base >= 0L, "Base must be greater or equal to 1");
        LettuceAssert.notNull((Object)targetTimeUnit, "Target TimeUnit must not be null");
        return () -> new DecorrelatedJitterDelay(lower, upper, base, targetTimeUnit);
    }

    public static Supplier<Delay> decorrelatedJitter(long lower, long upper, long base, TimeUnit unit) {
        LettuceAssert.isTrue(lower >= 0L, "Lower boundary must be greater or equal to 0");
        LettuceAssert.isTrue(upper > lower, "Upper boundary must be greater than the lower boundary");
        LettuceAssert.isTrue(base >= 0L, "Base must be greater or equal to 0");
        LettuceAssert.notNull((Object)unit, "TimeUnit must not be null");
        return Delay.decorrelatedJitter(Duration.ofNanos(unit.toNanos(lower)), Duration.ofNanos(unit.toNanos(upper)), base, unit);
    }

    protected static long randomBetween(long min, long max) {
        if (min >= max) {
            return min;
        }
        return ThreadLocalRandom.current().nextLong(min, max);
    }

    protected static Duration applyBounds(Duration calculatedValue, Duration lower, Duration upper) {
        if (calculatedValue.compareTo(lower) < 0) {
            return lower;
        }
        if (calculatedValue.compareTo(upper) > 0) {
            return upper;
        }
        return calculatedValue;
    }

    public static interface StatefulDelay {
        public void reset();
    }
}

