/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.reactor.core.publisher;

import java.util.function.Supplier;
import java.util.stream.Stream;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.Traces;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class CallSiteSupplierFactory
implements Supplier<Supplier<String>> {
    static final Supplier<Supplier<String>> supplier;

    CallSiteSupplierFactory() {
    }

    @Override
    public Supplier<String> get() {
        return supplier.get();
    }

    static {
        String[] strategyClasses = new String[]{CallSiteSupplierFactory.class.getName() + "$SharedSecretsCallSiteSupplierFactory", CallSiteSupplierFactory.class.getName() + "$ExceptionCallSiteSupplierFactory"};
        supplier = (Supplier)Stream.of(strategyClasses).flatMap(className -> {
            try {
                Class<?> clazz = Class.forName(className);
                Supplier function = (Supplier)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return Stream.of(function);
            }
            catch (LinkageError e) {}
            finally {
                return Stream.empty();
            }
        }).findFirst().orElseThrow(() -> new IllegalStateException("Valid strategy not found"));
    }

    static class ExceptionCallSiteSupplierFactory
    implements Supplier<Supplier<String>> {
        ExceptionCallSiteSupplierFactory() {
        }

        @Override
        public Supplier<String> get() {
            return new TracingException();
        }

        static class TracingException
        extends Throwable
        implements Supplier<String> {
            TracingException() {
            }

            @Override
            public String get() {
                StackTraceElement previousElement = null;
                StackTraceElement[] stackTrace = this.getStackTrace();
                for (int i = 4; i < stackTrace.length; ++i) {
                    StackTraceElement e = stackTrace[i];
                    String className = e.getClassName();
                    if (Traces.isUserCode(className)) {
                        StringBuilder sb = new StringBuilder();
                        if (previousElement != null) {
                            sb.append("\t").append(previousElement.toString()).append("\n");
                        }
                        sb.append("\t").append(e.toString()).append("\n");
                        return sb.toString();
                    }
                    if (!Traces.full && e.getLineNumber() <= 1) continue;
                    String classAndMethod = className + "." + e.getMethodName();
                    if (!Traces.full && Traces.shouldSanitize(classAndMethod)) continue;
                    previousElement = e;
                }
                return "";
            }
        }
    }

    static class SharedSecretsCallSiteSupplierFactory
    implements Supplier<Supplier<String>> {
        SharedSecretsCallSiteSupplierFactory() {
        }

        @Override
        public Supplier<String> get() {
            return new TracingException();
        }

        static {
            SharedSecrets.getJavaLangAccess();
        }

        static class TracingException
        extends Throwable
        implements Supplier<String> {
            static final JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();

            TracingException() {
            }

            @Override
            public String get() {
                int stackTraceDepth = javaLangAccess.getStackTraceDepth((Throwable)this);
                StackTraceElement previousElement = null;
                for (int i = 4; i < stackTraceDepth; ++i) {
                    StackTraceElement e = javaLangAccess.getStackTraceElement((Throwable)this, i);
                    String className = e.getClassName();
                    if (Traces.isUserCode(className)) {
                        StringBuilder sb = new StringBuilder();
                        if (previousElement != null) {
                            sb.append("\t").append(previousElement.toString()).append("\n");
                        }
                        sb.append("\t").append(e.toString()).append("\n");
                        return sb.toString();
                    }
                    if (!Traces.full && e.getLineNumber() <= 1) continue;
                    String classAndMethod = className + "." + e.getMethodName();
                    if (!Traces.full && Traces.shouldSanitize(classAndMethod)) continue;
                    previousElement = e;
                }
                return "";
            }
        }
    }
}

