/*
 * Decompiled with CFR 0.152.
 */
package net.william278.schematicupload.web;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import java.io.File;
import java.nio.file.Path;
import java.util.logging.Level;
import net.william278.schematicupload.SchematicUpload;
import net.william278.schematicupload.web.FileUploadServlet;
import net.william278.schematicupload.web.WebResourceServlet;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class WebServer {
    private static final SchematicUpload plugin = SchematicUpload.getInstance();
    private Server jettyServer;
    private final int port;

    private WebServer(int port) {
        this.port = port;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            int maxThreads = 32;
            int minThreads = 8;
            int idleTimeout = 120;
            QueuedThreadPool threadPool = new QueuedThreadPool(32, 8, 120);
            plugin.getLogger().log(Level.INFO, "Starting the internal webserver on port " + port);
            this.jettyServer = new Server((ThreadPool)threadPool);
            ServerConnector connector = new ServerConnector(this.jettyServer);
            connector.setPort(port);
            this.jettyServer.setConnectors(new Connector[]{connector});
            this.initialize();
        });
    }

    private void initialize() {
        try {
            String[] webResources;
            ServletContextHandler contextHandler = new ServletContextHandler();
            for (String resourcePath : webResources = new String[]{"index.html", "style.css", "uploader.js"}) {
                WebResourceServlet requestHandler = new WebResourceServlet(resourcePath);
                ServletHolder servletHolder = new ServletHolder((Servlet)requestHandler);
                contextHandler.addServlet(servletHolder, "/" + (resourcePath.equals("index.html") ? "" : resourcePath));
            }
            Path multipartTmpDir = new File(WebServer.plugin.getSettings().schematicDirectory.toFile(), ".temp").toPath();
            if (multipartTmpDir.toFile().mkdirs()) {
                plugin.getLogger().log(Level.INFO, "Preparing for upload...");
            }
            String location = multipartTmpDir.toString();
            long maxFileSize = 0x200000L;
            long maxRequestSize = 0x200000L;
            int fileSizeThreshold = 64;
            MultipartConfigElement multipartConfig = new MultipartConfigElement(location, 0x200000L, 0x200000L, 64);
            FileUploadServlet saveUploadServlet = new FileUploadServlet(WebServer.plugin.getSettings().schematicDirectory);
            ServletHolder servletHolder = new ServletHolder((Servlet)saveUploadServlet);
            servletHolder.getRegistration().setMultipartConfig(multipartConfig);
            contextHandler.addServlet(servletHolder, "/api");
            this.jettyServer.setHandler((Handler)contextHandler);
            this.jettyServer.start();
            this.jettyServer.join();
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to start the internal webserver.", e);
        }
    }

    public static WebServer start() {
        return new WebServer(WebServer.plugin.getSettings().webServerPort);
    }

    public void end() {
        try {
            plugin.getLogger().log(Level.INFO, "Shutting down the internal webserver.");
            this.jettyServer.stop();
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to gracefully shutdown the internal webserver.", e);
        }
    }
}

