/*
 * Decompiled with CFR 0.152.
 */
package net.william278.schematicupload;

import java.util.Objects;
import net.william278.schematicupload.command.UploadCommand;
import net.william278.schematicupload.config.Settings;
import net.william278.schematicupload.libraries.bstats.bukkit.Metrics;
import net.william278.schematicupload.libraries.bstats.charts.SimplePie;
import net.william278.schematicupload.util.MessageManager;
import net.william278.schematicupload.web.WebServer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public class SchematicUpload
extends JavaPlugin {
    private static final int METRICS_ID = 14611;
    private WebServer webServer;
    private static SchematicUpload instance;
    private Settings settings;

    public static SchematicUpload getInstance() {
        return instance;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void loadSettings() {
        this.settings = new Settings();
    }

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        this.loadSettings();
        MessageManager.loadMessages(this.settings.language);
        Objects.requireNonNull(this.getCommand("uploadschematic")).setExecutor((CommandExecutor)new UploadCommand());
        Objects.requireNonNull(this.getCommand("uploadschematic")).setTabCompleter((TabCompleter)new UploadCommand());
        this.webServer = WebServer.start();
        Metrics metrics = new Metrics(this, 14611);
        metrics.addCustomChart(new SimplePie("worldedit_type", () -> this.getSettings().worldEditPlugin));
    }

    public void onDisable() {
        if (this.webServer != null) {
            this.webServer.end();
        }
    }
}

