/*
 * Decompiled with CFR 0.152.
 */
package net.william278.schematicupload.libraries.minedown;

import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.william278.schematicupload.libraries.minedown.MineDown;

public class Util {
    private static final Pattern WRAP_PATTERN = Pattern.compile(" ", 16);
    private static Map<ChatColor, Color> legacyColors = new LinkedHashMap<ChatColor, Color>();

    public static void validate(boolean value, String message) throws IllegalArgumentException {
        if (!value) {
            throw new IllegalArgumentException(message);
        }
    }

    public static BaseComponent applyFormat(BaseComponent component, Collection<ChatColor> formats) {
        for (ChatColor format : formats) {
            if (format == ChatColor.BOLD) {
                component.setBold(Boolean.valueOf(true));
                continue;
            }
            if (format == ChatColor.ITALIC) {
                component.setItalic(Boolean.valueOf(true));
                continue;
            }
            if (format == ChatColor.UNDERLINE) {
                component.setUnderlined(Boolean.valueOf(true));
                continue;
            }
            if (format == ChatColor.STRIKETHROUGH) {
                component.setStrikethrough(Boolean.valueOf(true));
                continue;
            }
            if (format == ChatColor.MAGIC) {
                component.setObfuscated(Boolean.valueOf(true));
                continue;
            }
            if (format == ChatColor.RESET) {
                component.setBold(Boolean.valueOf(false));
                component.setItalic(Boolean.valueOf(false));
                component.setUnderlined(Boolean.valueOf(false));
                component.setStrikethrough(Boolean.valueOf(false));
                component.setObfuscated(Boolean.valueOf(false));
                component.setColor(ChatColor.WHITE);
                continue;
            }
            component.setColor(format);
        }
        if (component.getExtra() != null) {
            for (BaseComponent extra : component.getExtra()) {
                Util.applyFormat(extra, formats);
            }
        }
        return component;
    }

    @Deprecated
    public static ComponentBuilder applyFormat(ComponentBuilder builder, Set<ChatColor> formats) {
        HashMap<ChatColor, Boolean> formatMap = new HashMap<ChatColor, Boolean>();
        for (ChatColor format : formats) {
            formatMap.put(format, true);
        }
        return Util.applyFormat(builder, formatMap);
    }

    public static ComponentBuilder applyFormat(ComponentBuilder builder, Map<ChatColor, Boolean> formats) {
        for (Map.Entry<ChatColor, Boolean> e : formats.entrySet()) {
            if (e.getKey() == ChatColor.BOLD) {
                builder.bold(e.getValue().booleanValue());
                continue;
            }
            if (e.getKey() == ChatColor.ITALIC) {
                builder.italic(e.getValue().booleanValue());
                continue;
            }
            if (e.getKey() == ChatColor.UNDERLINE) {
                builder.underlined(e.getValue().booleanValue());
                continue;
            }
            if (e.getKey() == ChatColor.STRIKETHROUGH) {
                builder.strikethrough(e.getValue().booleanValue());
                continue;
            }
            if (e.getKey() == ChatColor.MAGIC) {
                builder.obfuscated(e.getValue().booleanValue());
                continue;
            }
            if (e.getKey() == ChatColor.RESET) {
                builder.bold(e.getValue() == false);
                builder.italic(e.getValue() == false);
                builder.underlined(e.getValue() == false);
                builder.strikethrough(e.getValue() == false);
                builder.obfuscated(e.getValue() == false);
                builder.color(ChatColor.WHITE);
                continue;
            }
            if (e.getValue().booleanValue()) {
                builder.color(e.getKey());
                continue;
            }
            if (builder.getCurrentComponent().getColor() != e.getKey()) continue;
            builder.color(null);
        }
        return builder;
    }

    public static boolean isDouble(String string, int index) {
        return index + 1 < string.length() && string.charAt(index) == string.charAt(index + 1);
    }

    public static boolean isFormat(ChatColor format) {
        return !MineDown.getFormatString(format).isEmpty();
    }

    public static Set<ChatColor> getFormats(BaseComponent component, boolean ignoreParent) {
        LinkedHashSet<ChatColor> formats = new LinkedHashSet<ChatColor>();
        if (!ignoreParent && component.isBold() || component.isBoldRaw() != null && component.isBoldRaw().booleanValue()) {
            formats.add(ChatColor.BOLD);
        }
        if (!ignoreParent && component.isItalic() || component.isItalicRaw() != null && component.isItalicRaw().booleanValue()) {
            formats.add(ChatColor.ITALIC);
        }
        if (!ignoreParent && component.isUnderlined() || component.isUnderlinedRaw() != null && component.isUnderlinedRaw().booleanValue()) {
            formats.add(ChatColor.UNDERLINE);
        }
        if (!ignoreParent && component.isStrikethrough() || component.isStrikethroughRaw() != null && component.isStrikethroughRaw().booleanValue()) {
            formats.add(ChatColor.STRIKETHROUGH);
        }
        if (!ignoreParent && component.isObfuscated() || component.isObfuscatedRaw() != null && component.isObfuscatedRaw().booleanValue()) {
            formats.add(ChatColor.MAGIC);
        }
        return formats;
    }

    public static int indexOfNotEscaped(String string, String chars) {
        return Util.indexOfNotEscaped(string, chars, 0);
    }

    public static int indexOfNotEscaped(String string, String chars, int fromIndex) {
        for (int i = fromIndex; i < string.length(); ++i) {
            int index = string.indexOf(chars, i);
            if (index == -1) {
                return -1;
            }
            if (Util.isEscaped(string, index)) continue;
            return index;
        }
        return -1;
    }

    public static boolean isEscaped(String string, int index) {
        int e;
        if (index - 1 > string.length()) {
            return false;
        }
        for (e = 0; index > e && string.charAt(index - e - 1) == '\\'; ++e) {
        }
        return e % 2 != 0;
    }

    public static String wrap(String string, int lineLength) {
        if (string.length() <= lineLength || string.contains("\n")) {
            return string;
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String s : WRAP_PATTERN.split(string)) {
            if (currentLine.length() + s.length() + 1 > lineLength) {
                int rest = lineLength - currentLine.length() - 1;
                if (rest > lineLength / 4 && s.length() > Math.min(rest * 2, lineLength / 4)) {
                    currentLine.append(" ").append(s, 0, rest);
                } else {
                    rest = 0;
                }
                lines.add(currentLine.toString());
                String restString = s.substring(rest);
                while (restString.length() >= lineLength) {
                    lines.add(restString.substring(0, lineLength));
                    restString = restString.substring(lineLength);
                }
                currentLine = new StringBuilder(restString);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(s);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return String.join((CharSequence)"\n", lines);
    }

    public static BaseComponent[] rgbColorsToLegacy(BaseComponent[] components) {
        for (BaseComponent component : components) {
            if (component.getColorRaw() != null && component.getColorRaw().getName().startsWith("#")) {
                component.setColor(Util.getClosestLegacy(new Color(Integer.parseInt(component.getColorRaw().getName().substring(1), 16))));
            }
            if (component.getExtra() == null) continue;
            Util.rgbColorsToLegacy(component.getExtra().toArray(new BaseComponent[0]));
        }
        return components;
    }

    public static ChatColor getClosestLegacy(Color color) {
        ChatColor closest = null;
        double smallestDistance = Double.MAX_VALUE;
        for (Map.Entry<ChatColor, Color> legacy : legacyColors.entrySet()) {
            double distance = Util.distance(color, legacy.getValue());
            if (!(distance < smallestDistance)) continue;
            smallestDistance = distance;
            closest = legacy.getKey();
        }
        return closest;
    }

    public static double distance(Color c1, Color c2) {
        if (c1.getRGB() == c2.getRGB()) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(c1.getRed() - c2.getRed(), 2.0) + Math.pow(c1.getGreen() - c2.getGreen(), 2.0) + Math.pow(c1.getBlue() - c2.getBlue(), 2.0));
    }

    @Deprecated
    public static List<ChatColor> createRainbow(int length, int phase, boolean rgb) {
        return Util.createRainbow((long)length, phase, rgb);
    }

    public static List<ChatColor> createRainbow(long length, int phase, boolean rgb) {
        ArrayList<ChatColor> colors = new ArrayList<ChatColor>();
        float fPhase = (float)phase / 10.0f;
        float center = 128.0f;
        float width = 127.0f;
        double frequency = Math.PI * 2 / (double)length;
        int i = 0;
        while ((long)i < length) {
            Color color = new Color((int)(Math.sin(frequency * (double)i + 2.0 + (double)fPhase) * (double)width + (double)center), (int)(Math.sin(frequency * (double)i + 0.0 + (double)fPhase) * (double)width + (double)center), (int)(Math.sin(frequency * (double)i + 4.0 + (double)fPhase) * (double)width + (double)center));
            if (rgb) {
                colors.add(ChatColor.of((Color)color));
            } else {
                ChatColor chatColor = Util.getClosestLegacy(color);
                if (colors.isEmpty() || chatColor != colors.get(colors.size() - 1)) {
                    colors.add(chatColor);
                }
            }
            ++i;
        }
        return colors;
    }

    @Deprecated
    public static List<ChatColor> createGradient(int length, List<ChatColor> gradient, boolean rgb) {
        return Util.createGradient((long)length, gradient, rgb);
    }

    public static List<ChatColor> createGradient(long length, List<ChatColor> gradient, boolean rgb) {
        ArrayList<ChatColor> colors = new ArrayList<ChatColor>();
        if (gradient.size() < 2 || length < 2L) {
            if (gradient.isEmpty()) {
                return gradient;
            }
            return Collections.singletonList(gradient.get(0));
        }
        float fPhase = 0.0f;
        float sectorLength = (float)(length - 1L) / (float)(gradient.size() - 1);
        float factorStep = 1.0f / sectorLength;
        long index = 0L;
        int colorIndex = 0;
        for (long i = 0L; i < length; ++i) {
            Color color;
            if (factorStep * (float)index > 1.0f) {
                ++colorIndex;
                index = 0L;
            }
            long l = index++;
            float factor = factorStep * ((float)l + fPhase);
            if (factor > 1.0f) {
                factor = 1.0f - (factor - 1.0f);
            }
            if ((color = Util.interpolate(Util.getColor(gradient.get(colorIndex), rgb), Util.getColor(gradient.get(Math.min(gradient.size() - 1, colorIndex + 1)), rgb), factor)) == null) continue;
            if (rgb) {
                colors.add(ChatColor.of((Color)color));
                continue;
            }
            ChatColor chatColor = Util.getClosestLegacy(color);
            if (!colors.isEmpty() && chatColor == colors.get(colors.size() - 1)) continue;
            colors.add(chatColor);
        }
        return colors;
    }

    private static Color getColor(ChatColor color, boolean rgb) {
        if (legacyColors.containsKey(color)) {
            return legacyColors.get(color);
        }
        if (color.getName().startsWith("#")) {
            Color c = new Color(Integer.parseInt(color.getName().substring(1), 16));
            if (rgb) {
                return c;
            }
            return legacyColors.get(Util.getClosestLegacy(c));
        }
        if (rgb) {
            return color.getColor();
        }
        return null;
    }

    private static Color interpolate(Color color1, Color color2, float factor) {
        if (color1 == null || color2 == null) {
            return null;
        }
        return new Color(Math.round((float)color1.getRed() + factor * (float)(color2.getRed() - color1.getRed())), Math.round((float)color1.getGreen() + factor * (float)(color2.getGreen() - color1.getGreen())), Math.round((float)color1.getBlue() + factor * (float)(color2.getBlue() - color1.getBlue())));
    }

    public static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classDoesntExist) {
            return false;
        }
    }

    public static boolean hasMethod(Class<?> clazz, String method, Class<?> ... parameter) {
        try {
            clazz.getMethod(method, parameter);
            return true;
        }
        catch (NoSuchMethodException methodDoesntExist) {
            return false;
        }
    }

    public static Method getMethod(Class<?> clazz, String method, Class<?> ... parameter) {
        try {
            return clazz.getMethod(method, parameter);
        }
        catch (NoSuchMethodException methodDoesntExist) {
            return null;
        }
    }

    static {
        legacyColors.put(ChatColor.BLACK, new Color(0));
        legacyColors.put(ChatColor.DARK_BLUE, new Color(170));
        legacyColors.put(ChatColor.DARK_GREEN, new Color(43520));
        legacyColors.put(ChatColor.DARK_AQUA, new Color(43690));
        legacyColors.put(ChatColor.DARK_RED, new Color(0xAA0000));
        legacyColors.put(ChatColor.DARK_PURPLE, new Color(0xAA00AA));
        legacyColors.put(ChatColor.GOLD, new Color(0xFFAA00));
        legacyColors.put(ChatColor.GRAY, new Color(0xAAAAAA));
        legacyColors.put(ChatColor.DARK_GRAY, new Color(0x555555));
        legacyColors.put(ChatColor.BLUE, new Color(0x5555FF));
        legacyColors.put(ChatColor.GREEN, new Color(0x55FF55));
        legacyColors.put(ChatColor.AQUA, new Color(0x55FFFF));
        legacyColors.put(ChatColor.RED, new Color(0xFF5555));
        legacyColors.put(ChatColor.LIGHT_PURPLE, new Color(0xFF55FF));
        legacyColors.put(ChatColor.YELLOW, new Color(0xFFFF55));
        legacyColors.put(ChatColor.WHITE, new Color(0xFFFFFF));
    }
}

