/*
 * Decompiled with CFR 0.152.
 */
package net.william278.schematicupload.upload;

import java.time.Instant;

public class UploadCode {
    public static final long CODE_TIMEOUT = 300L;
    public static final String RANDOM_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final int CODE_LENGTH = 8;
    private final String code;
    private final long generationTimestamp;

    public String getCode() {
        return this.code;
    }

    public boolean hasTimedOut() {
        return Instant.now().getEpochSecond() >= this.generationTimestamp + 300L;
    }

    private UploadCode(String code, long currentTime) {
        this.code = code;
        this.generationTimestamp = currentTime;
    }

    public static UploadCode generateRandomCode() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            result.append(RANDOM_CHARACTERS.charAt((int)Math.floor(Math.random() * (double)RANDOM_CHARACTERS.length())));
        }
        return new UploadCode(result.toString(), Instant.now().getEpochSecond());
    }
}

