/*
 * Decompiled with CFR 0.152.
 */
package net.william278.schematicupload.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.logging.Level;
import net.william278.schematicupload.SchematicUpload;
import net.william278.schematicupload.upload.UploadManager;
import net.william278.schematicupload.util.GZipUtil;
import net.william278.schematicupload.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;

public class FileUploadServlet
extends HttpServlet {
    private static final SchematicUpload plugin = SchematicUpload.getInstance();
    private final Path targetDirectory;

    public FileUploadServlet(Path targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        try {
            this.processParts(servletRequest, servletResponse, this.targetDirectory);
        }
        catch (ServletException | IOException e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to process upload", e);
            this.sendReply(servletResponse, 500, "An error occurred on the server");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processParts(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Path outputDir) throws ServletException, IOException {
        Part codePart = servletRequest.getPart("input-code");
        StringBuilder codeBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(codePart.getInputStream(), StandardCharsets.UTF_8));){
            int readerHead;
            while ((readerHead = ((Reader)reader).read()) != -1) {
                codeBuilder.append((char)readerHead);
            }
        }
        String code = codeBuilder.toString();
        UploadManager.ConsumptionResult consumptionResult = UploadManager.consumeCode(code);
        if (!consumptionResult.consumed()) {
            this.sendReply(servletResponse, 403, "Invalid or expired code");
            return;
        }
        Part filePart = servletRequest.getPart("file-upload");
        String fileName = code + "-" + filePart.getSubmittedFileName();
        if (StringUtil.isBlank((String)fileName)) {
            this.sendReply(servletResponse, 400, "Invalid file name (empty)");
            return;
        }
        if (fileName.length() >= 48) {
            this.sendReply(servletResponse, 400, "Invalid file name (too long)");
            return;
        }
        if (!fileName.endsWith(".schem") && !fileName.endsWith(".schematic")) {
            this.sendReply(servletResponse, 400, "Invalid file type extension");
            return;
        }
        String encodedFileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        Path outputFile = outputDir.resolve(encodedFileName);
        try (InputStream inputStream = filePart.getInputStream();
             OutputStream outputStream = Files.newOutputStream(outputFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            if (inputStream.available() > FileUploadServlet.plugin.getSettings().maxFileSize) {
                this.sendReply(servletResponse, 400, "Invalid schematic; too large. (Max size: " + FileUploadServlet.plugin.getSettings().maxFileSize / 1000 + "KB)");
                return;
            }
            if (!GZipUtil.isGZipped(inputStream)) {
                this.sendReply(servletResponse, 400, "Invalid schematic format.");
                return;
            }
            IO.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        consumptionResult.user().ifPresent(user -> {
            UploadManager.markAsUploaded(user);
            Player player = Bukkit.getServer().getPlayer(user);
            if (player != null) {
                MessageManager.sendMessage(player, "schematic_upload_complete", "//schem load " + fileName);
            }
        });
        this.sendReply(servletResponse, 200, fileName);
    }

    private void sendReply(HttpServletResponse response, int replyCode, String replyMessage) {
        try {
            response.setContentType("application/json");
            response.setStatus(replyCode);
            response.getWriter().println("{\"message\":\"" + replyMessage + "\"}");
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "IOException when trying to send HTTP reply", e);
        }
    }
}

