/*
 * Decompiled with CFR 0.152.
 */
package net.william278.schematicupload.web;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Objects;
import java.util.logging.Level;
import net.william278.schematicupload.SchematicUpload;
import net.william278.schematicupload.web.FileUploadServlet;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class WebServer {
    private static final SchematicUpload plugin = SchematicUpload.getInstance();
    private Server jettyServer;

    private WebServer(int port) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            int maxThreads = 32;
            int minThreads = 8;
            int idleTimeout = 120;
            QueuedThreadPool threadPool = new QueuedThreadPool(32, 8, 120);
            plugin.getLogger().log(Level.INFO, "Starting the internal webserver on port " + port);
            this.jettyServer = new Server((ThreadPool)threadPool);
            try (ServerConnector connector = new ServerConnector(this.jettyServer);){
                connector.setPort(port);
                this.jettyServer.setConnectors(new Connector[]{connector});
            }
            this.initialize();
        });
    }

    public void copyWebFiles(String source, final Path target) throws URISyntaxException, IOException {
        URI resource = Objects.requireNonNull(this.getClass().getResource("")).toURI();
        try (FileSystem fileSystem = FileSystems.newFileSystem(resource, Collections.emptyMap());){
            final Path jarPath = fileSystem.getPath(source, new String[0]);
            Files.walkFileTree(jarPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path currentTarget = target.resolve(jarPath.relativize(dir).toString());
                    Files.createDirectories(currentTarget, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, target.resolve(jarPath.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void initialize() {
        try {
            File targetDir = new File(plugin.getDataFolder(), "web");
            if (!targetDir.exists()) {
                plugin.getLogger().log(Level.INFO, "Generating files for the webserver...");
                if (!targetDir.mkdirs()) {
                    plugin.getLogger().log(Level.SEVERE, "Failed to create web directory");
                    return;
                }
                this.copyWebFiles("/web", Paths.get(targetDir.getPath(), new String[0]));
                File versionFile = new File(targetDir, "version.txt");
                if (!versionFile.exists() && !versionFile.createNewFile()) {
                    plugin.getLogger().log(Level.SEVERE, "Failed to create version file");
                    return;
                }
                Files.write(versionFile.toPath(), plugin.getDescription().getVersion().getBytes(), new OpenOption[0]);
            }
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setWelcomeFiles(new String[]{"index.html"});
            resourceHandler.setResourceBase(targetDir.getPath());
            resourceHandler.setDirectoriesListed(true);
            ContextHandler staticHandler = new ContextHandler("/");
            staticHandler.setHandler((Handler)resourceHandler);
            Path uploadTempDirectory = new File(WebServer.plugin.getSettings().schematicDirectory.toFile(), ".temp").toPath();
            if (uploadTempDirectory.toFile().mkdirs()) {
                plugin.getLogger().log(Level.INFO, "Prepared temporary upload folder for the webserver...");
            }
            long maxFileSize = 0x200000L;
            long maxRequestSize = 0x200000L;
            int fileSizeThreshold = 64;
            MultipartConfigElement multipartConfig = new MultipartConfigElement(uploadTempDirectory.toString(), 0x200000L, 0x200000L, 64);
            FileUploadServlet saveUploadServlet = new FileUploadServlet(WebServer.plugin.getSettings().schematicDirectory);
            ServletHolder servletHolder = new ServletHolder((Servlet)saveUploadServlet);
            servletHolder.getRegistration().setMultipartConfig(multipartConfig);
            ServletHandler apiHandler = new ServletHandler();
            apiHandler.addServletWithMapping(servletHolder, "/api");
            HandlerList handlers = new HandlerList();
            handlers.setHandlers(new Handler[]{staticHandler, apiHandler});
            this.jettyServer.setHandler((Handler)handlers);
            this.jettyServer.start();
            this.jettyServer.join();
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to start the internal webserver.", e);
        }
    }

    public static WebServer start() {
        return new WebServer(WebServer.plugin.getSettings().webServerPort);
    }

    public void end() {
        try {
            plugin.getLogger().log(Level.INFO, "Shutting down the internal webserver.");
            this.jettyServer.stop();
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to gracefully shutdown the internal webserver.", e);
        }
    }
}

