/*
 * Decompiled with CFR 0.152.
 */
package net.william278.schematicupload.upload;

import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.UUID;
import net.william278.schematicupload.SchematicUpload;
import net.william278.schematicupload.upload.UploadCode;

public class UploadManager {
    private static final SchematicUpload plugin = SchematicUpload.getInstance();
    private static final HashMap<UUID, UploadCode> uploadAuthorizationCodes = new HashMap();
    private static final HashMap<UUID, LinkedList<Long>> userUploadQueues = new HashMap();

    public static boolean canUpload(UUID player) {
        int maxUploadsPerPeriod = UploadManager.plugin.getSettings().uploadLimitCount;
        long periodLength = UploadManager.plugin.getSettings().uploadLimitPeriod * 60L;
        if (!userUploadQueues.containsKey(player)) {
            userUploadQueues.put(player, new LinkedList());
        }
        long currentTimestamp = Instant.now().getEpochSecond();
        if (!userUploadQueues.get(player).isEmpty()) {
            if (currentTimestamp > userUploadQueues.get(player).getLast() + periodLength) {
                userUploadQueues.get(player).removeLast();
            }
            return userUploadQueues.get(player).size() <= maxUploadsPerPeriod;
        }
        return true;
    }

    public static void markAsUploaded(UUID player) {
        long currentTimestamp = Instant.now().getEpochSecond();
        if (!userUploadQueues.containsKey(player)) {
            userUploadQueues.put(player, new LinkedList());
        }
        userUploadQueues.get(player).addFirst(currentTimestamp);
    }

    public static ConsumptionResult consumeCode(String input) {
        Optional<UUID> player;
        Object errorCode = "";
        if (input.length() != 8) {
            return new ConsumptionResult(false, Optional.empty(), "Invalid code; wrong length");
        }
        UUID uuidToRemove = null;
        boolean consumed = false;
        for (UUID uuid : uploadAuthorizationCodes.keySet()) {
            UploadCode code = uploadAuthorizationCodes.get(uuid);
            if (!code.getCode().equals(input)) continue;
            uuidToRemove = uuid;
            if (code.hasTimedOut()) {
                errorCode = "Invalid code; that code has expired";
                break;
            }
            if (!UploadManager.canUpload(uuid)) {
                errorCode = "You've reached the maximum uploads you can do in " + UploadManager.plugin.getSettings().uploadLimitPeriod + " minutes";
                break;
            }
            consumed = true;
            break;
        }
        if (uuidToRemove != null) {
            uploadAuthorizationCodes.remove(uuidToRemove);
            player = Optional.of(uuidToRemove);
        } else {
            player = Optional.empty();
        }
        return new ConsumptionResult(consumed, player, (String)errorCode);
    }

    public static UploadCode addCode(UUID player) {
        UploadCode code = UploadCode.generateRandomCode();
        uploadAuthorizationCodes.put(player, code);
        return code;
    }

    public record ConsumptionResult(boolean consumed, Optional<UUID> user, String errorCode) {
    }
}

