/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab;

import com.google.inject.Inject;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.william278.velocitab.api.VelocitabAPI;
import net.william278.velocitab.commands.VelocitabCommand;
import net.william278.velocitab.config.ConfigProvider;
import net.william278.velocitab.config.Formatter;
import net.william278.velocitab.config.Settings;
import net.william278.velocitab.config.TabGroups;
import net.william278.velocitab.hook.Hook;
import net.william278.velocitab.hook.LuckPermsHook;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.bstats.velocity.Metrics;
import net.william278.velocitab.libraries.desertwell.util.UpdateChecker;
import net.william278.velocitab.libraries.desertwell.util.Version;
import net.william278.velocitab.packet.PacketEventManager;
import net.william278.velocitab.packet.ScoreboardManager;
import net.william278.velocitab.providers.HookProvider;
import net.william278.velocitab.providers.LoggerProvider;
import net.william278.velocitab.providers.MetricProvider;
import net.william278.velocitab.providers.ScoreboardProvider;
import net.william278.velocitab.sorting.SortingManager;
import net.william278.velocitab.tab.PlayerTabList;
import net.william278.velocitab.vanish.VanishManager;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@Plugin(id="velocitab")
public class Velocitab
implements ConfigProvider,
ScoreboardProvider,
LoggerProvider,
HookProvider,
MetricProvider {
    private Settings settings;
    private TabGroups tabGroups;
    private final ProxyServer server;
    private final Logger logger;
    private final Path configDirectory;
    @Inject
    private PluginContainer pluginContainer;
    @Inject
    private Metrics.Factory metricsFactory;
    private PlayerTabList tabList;
    private List<Hook> hooks;
    private ScoreboardManager scoreboardManager;
    private SortingManager sortingManager;
    private VanishManager vanishManager;
    private PacketEventManager packetEventManager;

    @Inject
    public Velocitab(@NotNull ProxyServer server, @NotNull Logger logger, @DataDirectory Path configDirectory) {
        this.server = server;
        this.logger = logger;
        this.configDirectory = configDirectory;
    }

    @Subscribe
    public void onProxyInitialization(@NotNull ProxyInitializeEvent event) {
        this.checkCompatibility();
        this.loadConfigs();
        this.loadHooks();
        this.prepareVanishManager();
        this.prepareChannelManager();
        this.prepareScoreboard();
        this.registerCommands();
        this.registerMetrics();
        this.checkForUpdates();
        this.prepareAPI();
        this.logger.info("Successfully enabled Velocitab");
    }

    @Subscribe
    public void onProxyShutdown(@NotNull ProxyShutdownEvent event) {
        this.server.getScheduler().tasksByPlugin((Object)this).forEach(ScheduledTask::cancel);
        this.disableScoreboardManager();
        this.getLuckPermsHook().ifPresent(LuckPermsHook::closeEvent);
        VelocitabAPI.unregister();
        this.logger.info("Successfully disabled Velocitab");
    }

    @NotNull
    public Formatter getFormatter() {
        return this.getSettings().getFormatter();
    }

    public void loadConfigs() {
        this.loadSettings();
        this.loadTabGroups();
    }

    private void prepareVanishManager() {
        this.vanishManager = new VanishManager(this);
    }

    private void prepareChannelManager() {
        this.packetEventManager = new PacketEventManager(this);
    }

    @Override
    public Velocitab getPlugin() {
        return this;
    }

    @Override
    @NotNull
    public Optional<ScoreboardManager> getScoreboardManager() {
        return Optional.ofNullable(this.scoreboardManager);
    }

    private void prepareAPI() {
        VelocitabAPI.register(this);
    }

    private void registerCommands() {
        BrigadierCommand command = new VelocitabCommand(this).command();
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(command).plugin((Object)this).build(), (Command)command);
    }

    @NotNull
    public PluginDescription getDescription() {
        return this.pluginContainer.getDescription();
    }

    @Override
    @NotNull
    public Version getVelocityVersion() {
        return Version.fromString(this.server.getVersion().getVersion(), "-");
    }

    @NotNull
    public Version getVersion() {
        return Version.fromString((String)this.getDescription().getVersion().orElseThrow(), "-");
    }

    private void checkForUpdates() {
        if (!this.getSettings().isCheckForUpdates()) {
            return;
        }
        this.getUpdateChecker().check().thenAccept(checked -> {
            if (!checked.isUpToDate()) {
                this.log(Level.WARN, "A new version of Velocitab is available: " + checked.getLatestVersion(), new Throwable[0]);
            }
        });
    }

    @NotNull
    public UpdateChecker getUpdateChecker() {
        return UpdateChecker.builder().currentVersion(this.getVersion()).endpoint(UpdateChecker.Endpoint.MODRINTH).resource("velocitab").build();
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public TabGroups getTabGroups() {
        return this.tabGroups;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Path getConfigDirectory() {
        return this.configDirectory;
    }

    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    @Override
    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    @Override
    public PlayerTabList getTabList() {
        return this.tabList;
    }

    @Override
    public List<Hook> getHooks() {
        return this.hooks;
    }

    @Override
    public SortingManager getSortingManager() {
        return this.sortingManager;
    }

    public VanishManager getVanishManager() {
        return this.vanishManager;
    }

    public PacketEventManager getPacketEventManager() {
        return this.packetEventManager;
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void setTabGroups(TabGroups tabGroups) {
        this.tabGroups = tabGroups;
    }

    @Override
    public void setTabList(PlayerTabList tabList) {
        this.tabList = tabList;
    }

    @Override
    public void setHooks(List<Hook> hooks) {
        this.hooks = hooks;
    }

    @Override
    public void setScoreboardManager(ScoreboardManager scoreboardManager) {
        this.scoreboardManager = scoreboardManager;
    }

    @Override
    public void setSortingManager(SortingManager sortingManager) {
        this.sortingManager = sortingManager;
    }
}

