/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import java.util.List;
import net.william278.velocitab.config.ConfigValidator;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.configlib.Configuration;
import net.william278.velocitab.tab.Nametag;

@Configuration
public class TabGroups
implements ConfigValidator {
    public static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503      Velocitab TabGroups     \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/velocitab\n\u2517\u2578 Documentation: https://william278.net/docs/velocitab";
    public List<Group> groups = List.of(new Group("default", List.of("&rainbow&Running Velocitab by William278"), List.of("[There are currently %players_online%/%max_players_online% players online](gray)"), "&7[%server%] &f%prefix%%username%", new Nametag("&f%prefix%", "&f%suffix%"), List.of("lobby", "survival", "creative", "minigames", "skyblock", "prison", "hub"), List.of("%role_weight%", "%username_lower%"), 1000, 1000));

    @NotNull
    public Group getGroupFromName(@NotNull String name) {
        return this.groups.stream().filter(group -> group.name().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("No group with name " + name + " found"));
    }

    @NotNull
    public Group getGroupFromServer(@NotNull String server) {
        for (Group group : this.groups) {
            if (!group.servers().contains(server)) continue;
            return group;
        }
        return this.getGroupFromName("default");
    }

    public int getPosition(@NotNull Group group) {
        return this.groups.indexOf(group) + 1;
    }

    @Override
    public void validateConfig() {
        if (this.groups.isEmpty()) {
            throw new IllegalStateException("No tab groups defined in config");
        }
        if (this.groups.stream().noneMatch(group -> group.name().equals("default"))) {
            throw new IllegalStateException("No default tab group defined in config");
        }
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    private TabGroups() {
    }
}

