/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.configlib;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.william278.velocitab.libraries.configlib.ConfigurationElements;
import net.william278.velocitab.libraries.configlib.ConfigurationException;
import net.william278.velocitab.libraries.configlib.ConfigurationProperties;
import net.william278.velocitab.libraries.configlib.FieldExtractors;
import net.william278.velocitab.libraries.configlib.Reflect;
import net.william278.velocitab.libraries.configlib.TypeSerializer;
import net.william278.velocitab.libraries.configlib.Validator;

final class ConfigurationSerializer<T>
extends TypeSerializer<T, ConfigurationElements.FieldElement> {
    ConfigurationSerializer(Class<T> configurationType, ConfigurationProperties properties) {
        super(Validator.requireConfigurationClass(configurationType), properties);
    }

    @Override
    public T deserialize(Map<?, ?> serializedConfiguration) {
        Object result = Reflect.callNoParamConstructor(this.type);
        for (ConfigurationElements.FieldElement element : this.elements()) {
            String formattedName = this.formatter.format(element.name());
            if (!serializedConfiguration.containsKey(formattedName)) continue;
            Object serializedValue = serializedConfiguration.get(formattedName);
            Field field = element.element();
            if (serializedValue == null && this.properties.inputNulls()) {
                ConfigurationSerializer.requireNonPrimitiveFieldType(field);
                Reflect.setValue(field, result, null);
                continue;
            }
            if (serializedValue == null) continue;
            Object deserializeValue = this.deserialize(element, serializedValue);
            Reflect.setValue(field, result, deserializeValue);
        }
        return result;
    }

    @Override
    protected void requireSerializableElements() {
        if (this.serializers.isEmpty()) {
            String msg = "Configuration class '" + this.type.getSimpleName() + "' does not contain any (de-)serializable fields.";
            throw new ConfigurationException(msg);
        }
    }

    @Override
    protected String baseDeserializeExceptionMessage(ConfigurationElements.FieldElement element, Object value) {
        return "Deserialization of value '%s' with type '%s' for field '%s' failed.".formatted(value, value.getClass(), element.element());
    }

    @Override
    protected List<ConfigurationElements.FieldElement> elements() {
        return FieldExtractors.CONFIGURATION.extract(this.type).filter(this.properties.getFieldFilter()).map(ConfigurationElements.FieldElement::new).toList();
    }

    @Override
    T newDefaultInstance() {
        return Reflect.callNoParamConstructor(this.type);
    }

    private static void requireNonPrimitiveFieldType(Field field) {
        if (field.getType().isPrimitive()) {
            String msg = "Cannot set field '%s' to null value. Primitive types cannot be assigned null.".formatted(field);
            throw new ConfigurationException(msg);
        }
    }

    Class<T> getConfigurationType() {
        return this.type;
    }
}

