/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.tab;

import com.velocitypowered.api.proxy.Player;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.PlayerTabList;

public class VanishTabList {
    private final Velocitab plugin;
    private final PlayerTabList tabList;

    public VanishTabList(Velocitab plugin, PlayerTabList tabList) {
        this.plugin = plugin;
        this.tabList = tabList;
    }

    public void vanishPlayer(@NotNull TabPlayer tabPlayer) {
        this.tabList.getPlayers().values().forEach(p -> {
            if (p.getPlayer().equals(tabPlayer.getPlayer())) {
                return;
            }
            if (!this.plugin.getVanishManager().canSee(p.getPlayer().getUsername(), tabPlayer.getPlayer().getUsername())) {
                p.getPlayer().getTabList().removeEntry(tabPlayer.getPlayer().getUniqueId());
            }
        });
    }

    public void unVanishPlayer(@NotNull TabPlayer tabPlayer) {
        UUID uuid = tabPlayer.getPlayer().getUniqueId();
        tabPlayer.getDisplayName(this.plugin).thenAccept(c -> this.tabList.getPlayers().values().forEach(p -> {
            if (p.getPlayer().equals(tabPlayer.getPlayer())) {
                return;
            }
            if (!p.getPlayer().getTabList().containsEntry(uuid)) {
                p.getPlayer().getTabList().addEntry(this.tabList.createEntry(tabPlayer, p.getPlayer().getTabList(), (Component)c));
            } else {
                p.getPlayer().getTabList().getEntry(uuid).ifPresent(entry -> entry.setDisplayName(c));
            }
        }));
    }

    public void recalculateVanishForPlayer(@NotNull TabPlayer tabPlayer) {
        Player player = tabPlayer.getPlayer();
        List<String> serversInGroup = tabPlayer.getGroup().servers();
        this.plugin.getServer().getAllPlayers().forEach(p -> {
            boolean canSee;
            if (p.equals(player)) {
                return;
            }
            Optional<TabPlayer> targetOptional = this.tabList.getTabPlayer((Player)p);
            if (targetOptional.isEmpty()) {
                return;
            }
            TabPlayer target = targetOptional.get();
            String serverName = target.getServerName();
            if (this.plugin.getSettings().isOnlyListPlayersInSameGroup() && !serversInGroup.contains(serverName)) {
                return;
            }
            boolean bl = canSee = !this.plugin.getVanishManager().isVanished(p.getUsername()) || this.plugin.getVanishManager().canSee(player.getUsername(), p.getUsername());
            if (!canSee) {
                player.getTabList().removeEntry(p.getUniqueId());
                this.plugin.getScoreboardManager().ifPresent(s -> s.recalculateVanishForPlayer(tabPlayer, target, false));
            } else if (!player.getTabList().containsEntry(p.getUniqueId())) {
                this.tabList.createEntry(target, player.getTabList()).thenAccept(e -> {
                    player.getTabList().addEntry(e);
                    this.plugin.getScoreboardManager().ifPresent(s -> s.recalculateVanishForPlayer(tabPlayer, target, true));
                });
            }
        });
    }
}

