/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.desertwell.about.AboutMenu;
import net.william278.velocitab.player.TabPlayer;

public final class VelocitabCommand {
    private static final TextColor MAIN_COLOR = TextColor.color((int)64410);
    private final AboutMenu aboutMenu;
    private final Velocitab plugin;

    public VelocitabCommand(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.aboutMenu = AboutMenu.builder().title((Component)Component.text((String)"Velocitab")).description((Component)Component.text((String)((String)plugin.getDescription().getDescription().orElseThrow()))).version(plugin.getVersion()).credits("Author", AboutMenu.Credit.of("William278").description("Click to visit website").url("https://william278.net")).credits("Contributors", AboutMenu.Credit.of("AlexDev03").description("Code"), AboutMenu.Credit.of("Ironboundred").description("Code"), AboutMenu.Credit.of("Emibergo02").description("Code"), AboutMenu.Credit.of("FreeMonoid").description("Code"), AboutMenu.Credit.of("4drian3d").description("Code")).buttons(AboutMenu.Link.of("https://william278.net/docs/velocitab").text("Docs").icon("\u26cf"), AboutMenu.Link.of("https://discord.gg/tVYhJfyDWG").text("Discord").icon("\u2b50").color(TextColor.color((int)6779893)), AboutMenu.Link.of("https://modrinth.com/plugin/velocitab").text("Modrinth").icon("\u25ce").color(TextColor.color((int)5804355))).build();
    }

    @NotNull
    public BrigadierCommand command() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"velocitab").executes(ctx -> {
            this.sendAboutInfo((CommandSource)ctx.getSource());
            return 1;
        })).then(LiteralArgumentBuilder.literal((String)"about").executes(ctx -> {
            this.sendAboutInfo((CommandSource)ctx.getSource());
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"name").requires(src -> src.hasPermission("velocitab.command.name"))).then(RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Object patt4048$temp = ctx.getSource();
            if (!(patt4048$temp instanceof Player)) {
                ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)"You must be a player to use this command!", (TextColor)MAIN_COLOR));
                return 1;
            }
            Player player = (Player)patt4048$temp;
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            Optional<TabPlayer> tabPlayer = this.plugin.getTabList().getTabPlayer(player);
            if (tabPlayer.isEmpty()) {
                ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)"You must in a correct server!", (TextColor)MAIN_COLOR));
                return 1;
            }
            tabPlayer.get().setCustomName(name);
            this.plugin.getTabList().updatePlayerDisplayName(tabPlayer.get());
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"reload").requires(src -> src.hasPermission("velocitab.command.reload"))).executes(ctx -> {
            this.plugin.loadConfigs();
            this.plugin.getTabList().reloadUpdate();
            ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)"Velocitab has been reloaded!", (TextColor)MAIN_COLOR));
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"update").requires(src -> src.hasPermission("velocitab.command.update"))).executes(ctx -> {
            this.plugin.getUpdateChecker().check().thenAccept(checked -> {
                if (checked.isUpToDate()) {
                    ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)("Velocitab is up to date! (Running v" + this.plugin.getVersion() + ")"), (TextColor)MAIN_COLOR));
                    return;
                }
                ((CommandSource)ctx.getSource()).sendMessage((Component)Component.text((String)("An update for velocitab is available. Please update to " + checked.getLatestVersion()), (TextColor)MAIN_COLOR));
            });
            return 1;
        }));
        return new BrigadierCommand(builder);
    }

    private void sendAboutInfo(@NotNull CommandSource source) {
        source.sendMessage((Component)this.aboutMenu.toComponent());
    }
}

