/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.player;

import com.velocitypowered.api.proxy.Player;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.config.Placeholder;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.libraries.commons.lang3.ObjectUtils;
import net.william278.velocitab.player.Role;
import net.william278.velocitab.tab.Nametag;
import net.william278.velocitab.tab.PlayerTabList;

public final class TabPlayer
implements Comparable<TabPlayer> {
    private final Player player;
    private Role role;
    private int headerIndex = 0;
    private int footerIndex = 0;
    private Component lastDisplayName;
    private String teamName;
    @Nullable
    private String customName;
    @Nullable
    private String lastServer;
    @NotNull
    private Group group;
    private boolean loaded;

    public TabPlayer(@NotNull Player player, @NotNull Role role, @NotNull Group group) {
        this.player = player;
        this.role = role;
        this.group = group;
    }

    @NotNull
    public String getRoleWeightString() {
        return this.getRole().getWeightString();
    }

    @NotNull
    public String getServerName() {
        return this.player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse(ObjectUtils.firstNonNull(this.lastServer, "unknown"));
    }

    public int getServerGroupPosition(@NotNull Velocitab plugin) {
        return plugin.getTabGroups().getPosition(this.group);
    }

    @NotNull
    public String getServerDisplayName(@NotNull Velocitab plugin) {
        return plugin.getSettings().getServerDisplayName(this.getServerName());
    }

    @NotNull
    public CompletableFuture<Component> getDisplayName(@NotNull Velocitab plugin) {
        return ((CompletableFuture)Placeholder.replace(this.group.format(), plugin, this).thenApply(formatted -> plugin.getFormatter().format((String)formatted, this, plugin))).thenApply(c -> {
            this.lastDisplayName = c;
            return this.lastDisplayName;
        });
    }

    @NotNull
    public CompletableFuture<Nametag> getNametag(@NotNull Velocitab plugin) {
        return Placeholder.replace(this.group.nametag(), plugin, this);
    }

    @NotNull
    public CompletableFuture<String> getTeamName(@NotNull Velocitab plugin) {
        return plugin.getSortingManager().getTeamName(this).thenApply(teamName -> {
            this.teamName = teamName;
            return this.teamName;
        });
    }

    public Optional<String> getLastTeamName() {
        return Optional.ofNullable(this.teamName);
    }

    public CompletableFuture<Void> sendHeaderAndFooter(@NotNull PlayerTabList tabList) {
        return tabList.getHeader(this).thenCompose(header -> tabList.getFooter(this).thenAccept(footer -> this.player.sendPlayerListHeaderAndFooter(header, footer)));
    }

    public void incrementIndexes() {
        this.incrementHeaderIndex();
        this.incrementFooterIndex();
    }

    public void incrementHeaderIndex() {
        ++this.headerIndex;
        if (this.headerIndex >= this.group.headers().size()) {
            this.headerIndex = 0;
        }
    }

    public void incrementFooterIndex() {
        ++this.footerIndex;
        if (this.footerIndex >= this.group.footers().size()) {
            this.footerIndex = 0;
        }
    }

    public Optional<String> getCustomName() {
        return Optional.ofNullable(this.customName);
    }

    @Override
    public int compareTo(@NotNull TabPlayer o) {
        int roleDifference = this.role.compareTo(o.role);
        if (roleDifference == 0) {
            return this.player.getUsername().compareTo(o.player.getUsername());
        }
        return roleDifference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TabPlayer)) return false;
        TabPlayer other = (TabPlayer)obj;
        if (!this.player.getUniqueId().equals(other.player.getUniqueId())) return false;
        return true;
    }

    public String toString() {
        return "TabPlayer{player=" + this.player + ", role=" + this.role + ", headerIndex=" + this.headerIndex + ", footerIndex=" + this.footerIndex + ", lastDisplayname=" + this.lastDisplayName + ", teamName='" + this.teamName + "', lastServer='" + this.lastServer + "', group=" + this.group.name() + ", loaded=" + this.loaded + "}";
    }

    public Player getPlayer() {
        return this.player;
    }

    public Role getRole() {
        return this.role;
    }

    public int getHeaderIndex() {
        return this.headerIndex;
    }

    public int getFooterIndex() {
        return this.footerIndex;
    }

    public Component getLastDisplayName() {
        return this.lastDisplayName;
    }

    public String getTeamName() {
        return this.teamName;
    }

    @Nullable
    public String getLastServer() {
        return this.lastServer;
    }

    @NotNull
    public Group getGroup() {
        return this.group;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public void setCustomName(@Nullable String customName) {
        this.customName = customName;
    }

    public void setLastServer(@Nullable String lastServer) {
        this.lastServer = lastServer;
    }

    public void setGroup(@NotNull Group group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        this.group = group;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }
}

