/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.configlib.Configuration;
import net.william278.velocitab.libraries.desertwell.util.Version;

@Configuration
public class Metadata {
    private String velocityApiVersion;
    private int velocityMinimumBuild;

    public void validateApiVersion(@NotNull Version version) {
        if (version.compareTo(Version.fromString(this.velocityApiVersion)) < 0) {
            String serverVersion = version.toStringWithoutMetadata();
            throw new IllegalStateException("Your Velocity API version (" + serverVersion + ") is not supported! Disabling Velocitab. Please update to at least Velocity v" + this.velocityApiVersion + " build #" + this.velocityMinimumBuild + " or newer.");
        }
    }

    public void validateBuild(@NotNull Version version) {
        int serverBuild = this.getBuildNumber(version.toString());
        if (serverBuild < this.velocityMinimumBuild) {
            throw new IllegalStateException("Your Velocity build version (#" + serverBuild + ") is not supported! Disabling Velocitab. Please update to at least Velocity v" + this.velocityApiVersion + " build #" + this.velocityMinimumBuild + " or newer.");
        }
    }

    private int getBuildNumber(@NotNull String proxyVersion) {
        Matcher matcher = Pattern.compile(".*-b(\\d+).*").matcher(proxyVersion);
        if (matcher.find(1)) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new IllegalArgumentException("No build number found for proxy version: " + proxyVersion);
    }

    public String getVelocityApiVersion() {
        return this.velocityApiVersion;
    }

    public int getVelocityMinimumBuild() {
        return this.velocityMinimumBuild;
    }

    private Metadata() {
    }
}

