/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.ConfigValidator;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.configlib.Configuration;
import net.william278.velocitab.tab.Nametag;

@Configuration
public class TabGroups
implements ConfigValidator {
    public static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503      Velocitab TabGroups     \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information: https://william278.net/project/velocitab\n\u2517\u2578 Documentation: https://william278.net/docs/velocitab";
    private static final Group DEFAULT_GROUP = new Group("default", List.of("&rainbow&Running Velocitab by William278"), List.of("[There are currently %players_online%/%max_players_online% players online](gray)"), "&7[%server%] &f%prefix%%username%", new Nametag("&f%prefix%", "&f%suffix%"), List.of("lobby", "survival", "creative", "minigames", "skyblock", "prison", "hub"), List.of("%role_weight%", "%username_lower%"), false, 1000, 1000);
    public List<Group> groups = List.of(DEFAULT_GROUP);

    @NotNull
    public Group getGroupFromName(@NotNull String name) {
        return this.groups.stream().filter(group -> group.name().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("No group with name " + name + " found"));
    }

    @NotNull
    public Optional<Group> getGroup(@NotNull String name) {
        return this.groups.stream().filter(group -> group.name().equals(name)).findFirst();
    }

    @NotNull
    public Group getGroupFromServer(@NotNull String server) {
        for (Group group : this.groups) {
            if (!group.servers().contains(server)) continue;
            return group;
        }
        return this.getGroupFromName("default");
    }

    public int getPosition(@NotNull Group group) {
        return this.groups.indexOf(group) + 1;
    }

    @Override
    public void validateConfig(@NotNull Velocitab plugin) {
        if (this.groups.isEmpty()) {
            throw new IllegalStateException("No tab groups defined in config");
        }
        if (this.groups.stream().noneMatch(group -> group.name().equals("default"))) {
            throw new IllegalStateException("No default tab group defined in config");
        }
        Multimap<Group, String> missingKeys = this.getMissingKeys();
        if (missingKeys.isEmpty()) {
            return;
        }
        this.fixMissingKeys(plugin, missingKeys);
    }

    @NotNull
    private Multimap<Group, String> getMissingKeys() {
        SetMultimap missingKeys = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
        for (Group group : this.groups) {
            if (group.format() == null) {
                missingKeys.put((Object)group, (Object)"format");
            }
            if (group.nametag() == null) {
                missingKeys.put((Object)group, (Object)"nametag");
            }
            if (group.servers() == null) {
                missingKeys.put((Object)group, (Object)"servers");
            }
            if (group.sortingPlaceholders() != null) continue;
            missingKeys.put((Object)group, (Object)"sortingPlaceholders");
        }
        return missingKeys;
    }

    private void fixMissingKeys(@NotNull Velocitab plugin, @NotNull Multimap<Group, String> missingKeys) {
        missingKeys.forEach((group, keys) -> {
            plugin.log("Missing required key(s) " + keys + " for group " + group.name());
            plugin.log("Using default values for group " + group.name());
            this.groups.remove(group);
            group = new Group(group.name(), group.headers(), group.footers(), group.format() == null ? DEFAULT_GROUP.format() : group.format(), group.nametag() == null ? DEFAULT_GROUP.nametag() : group.nametag(), group.servers() == null ? DEFAULT_GROUP.servers() : group.servers(), group.sortingPlaceholders() == null ? DEFAULT_GROUP.sortingPlaceholders() : group.sortingPlaceholders(), group.collisions(), group.headerFooterUpdateRate(), group.placeholderUpdateRate());
            this.groups.add((Group)group);
        });
        plugin.saveTabGroups();
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    private TabGroups() {
    }
}

