/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.configlib;

import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.william278.velocitab.libraries.configlib.ConfigurationElements;
import net.william278.velocitab.libraries.configlib.ConfigurationException;
import net.william278.velocitab.libraries.configlib.ConfigurationProperties;
import net.william278.velocitab.libraries.configlib.Reflect;
import net.william278.velocitab.libraries.configlib.TypeSerializer;
import net.william278.velocitab.libraries.configlib.Validator;

final class RecordSerializer<R>
extends TypeSerializer<R, ConfigurationElements.RecordComponentElement> {
    RecordSerializer(Class<R> recordType, ConfigurationProperties properties) {
        super(Validator.requireRecord(recordType), properties);
    }

    @Override
    public R deserialize(Map<?, ?> serializedConfiguration) {
        List<ConfigurationElements.RecordComponentElement> elements = this.elements();
        Object[] constructorArguments = new Object[elements.size()];
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            ConfigurationElements.RecordComponentElement element = elements.get(i);
            String formattedName = this.formatter.format(element.name());
            if (!serializedConfiguration.containsKey(formattedName)) {
                constructorArguments[i] = Reflect.getDefaultValue(element.type());
                continue;
            }
            Object serializedValue = serializedConfiguration.get(formattedName);
            RecordComponent recordComponent = element.element();
            if (serializedValue == null && this.properties.inputNulls()) {
                RecordSerializer.requireNonPrimitiveComponentType(recordComponent);
                constructorArguments[i] = null;
                continue;
            }
            constructorArguments[i] = serializedValue == null ? Reflect.getDefaultValue(element.type()) : this.deserialize(element, serializedValue);
        }
        return Reflect.callCanonicalConstructor(this.type, constructorArguments);
    }

    @Override
    protected void requireSerializableElements() {
        if (this.serializers.isEmpty()) {
            String msg = "Record type '%s' does not define any components.".formatted(this.type.getSimpleName());
            throw new ConfigurationException(msg);
        }
    }

    @Override
    protected String baseDeserializeExceptionMessage(ConfigurationElements.RecordComponentElement element, Object value) {
        return "Deserialization of value '%s' with type '%s' for component '%s' of record '%s' failed.".formatted(value, value.getClass(), element.element(), element.declaringType());
    }

    @Override
    protected List<ConfigurationElements.RecordComponentElement> elements() {
        return Arrays.stream(this.type.getRecordComponents()).map(ConfigurationElements.RecordComponentElement::new).toList();
    }

    @Override
    R newDefaultInstance() {
        return (R)(Reflect.hasDefaultConstructor(this.type) ? Reflect.callNoParamConstructor(this.type) : Reflect.callCanonicalConstructorWithDefaultValues(this.type));
    }

    private static void requireNonPrimitiveComponentType(RecordComponent component) {
        if (component.getType().isPrimitive()) {
            String msg = "Cannot set component '%s' of record type '%s' to null. Primitive types cannot be assigned null values.".formatted(component, component.getDeclaringRecord());
            throw new ConfigurationException(msg);
        }
    }

    Class<R> getRecordType() {
        return this.type;
    }
}

