/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.packet.ScoreboardManager;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.Nametag;

public class UpdateTeamsPacket
implements MinecraftPacket {
    private final Velocitab plugin;
    private String teamName;
    private UpdateMode mode;
    private Component displayName;
    private List<FriendlyFlag> friendlyFlags;
    private NametagVisibility nametagVisibility;
    private CollisionRule collisionRule;
    private int color;
    private Component prefix;
    private Component suffix;
    private List<String> entities;

    public UpdateTeamsPacket(@NotNull Velocitab plugin) {
        this.plugin = plugin;
    }

    @NotNull
    protected static UpdateTeamsPacket create(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer, @NotNull String teamName, @NotNull Nametag nametag, String ... teamMembers) {
        return new UpdateTeamsPacket(plugin).teamName(teamName.length() > 16 ? teamName.substring(0, 16) : teamName).mode(UpdateMode.CREATE_TEAM).displayName((Component)Component.empty()).friendlyFlags(List.of(FriendlyFlag.CAN_HURT_FRIENDLY)).nametagVisibility(UpdateTeamsPacket.isNametagPresent(nametag, plugin) ? NametagVisibility.ALWAYS : NametagVisibility.NEVER).collisionRule(tabPlayer.getGroup().collisions() ? CollisionRule.ALWAYS : CollisionRule.NEVER).color(UpdateTeamsPacket.getLastColor(tabPlayer, nametag.prefix(), plugin)).prefix(nametag.getPrefixComponent(plugin, tabPlayer)).suffix(nametag.getSuffixComponent(plugin, tabPlayer)).entities(Arrays.asList(teamMembers));
    }

    private static boolean isNametagPresent(@NotNull Nametag nametag, @NotNull Velocitab plugin) {
        if (!plugin.getSettings().isRemoveNametags()) {
            return true;
        }
        return !nametag.prefix().isEmpty() || !nametag.suffix().isEmpty();
    }

    @NotNull
    protected static UpdateTeamsPacket changeNametag(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer, @NotNull String teamName, @NotNull Nametag nametag) {
        return new UpdateTeamsPacket(plugin).teamName(teamName.length() > 16 ? teamName.substring(0, 16) : teamName).mode(UpdateMode.UPDATE_INFO).displayName((Component)Component.empty()).friendlyFlags(List.of(FriendlyFlag.CAN_HURT_FRIENDLY)).nametagVisibility(UpdateTeamsPacket.isNametagPresent(nametag, plugin) ? NametagVisibility.ALWAYS : NametagVisibility.NEVER).collisionRule(tabPlayer.getGroup().collisions() ? CollisionRule.ALWAYS : CollisionRule.NEVER).color(UpdateTeamsPacket.getLastColor(tabPlayer, nametag.prefix(), plugin)).prefix(nametag.getPrefixComponent(plugin, tabPlayer)).suffix(nametag.getSuffixComponent(plugin, tabPlayer));
    }

    @NotNull
    protected static UpdateTeamsPacket addToTeam(@NotNull Velocitab plugin, @NotNull String teamName, String ... teamMembers) {
        return new UpdateTeamsPacket(plugin).teamName(teamName.length() > 16 ? teamName.substring(0, 16) : teamName).mode(UpdateMode.ADD_PLAYERS).entities(Arrays.asList(teamMembers));
    }

    @NotNull
    protected static UpdateTeamsPacket removeFromTeam(@NotNull Velocitab plugin, @NotNull String teamName, String ... teamMembers) {
        return new UpdateTeamsPacket(plugin).teamName(teamName.length() > 16 ? teamName.substring(0, 16) : teamName).mode(UpdateMode.REMOVE_PLAYERS).entities(Arrays.asList(teamMembers));
    }

    @NotNull
    protected static UpdateTeamsPacket removeTeam(@NotNull Velocitab plugin, @NotNull String teamName) {
        return new UpdateTeamsPacket(plugin).teamName(teamName.length() > 16 ? teamName.substring(0, 16) : teamName).mode(UpdateMode.REMOVE_TEAM);
    }

    public static int getLastColor(@NotNull TabPlayer tabPlayer, @Nullable String text, @NotNull Velocitab plugin) {
        if (tabPlayer.getTeamColor() != null) {
            text = "&" + tabPlayer.getTeamColor().colorChar();
        }
        if (text == null) {
            return 15;
        }
        text = (String)text + "z";
        Component component = plugin.getFormatter().emptyFormat((String)text);
        text = LegacyComponentSerializer.legacyAmpersand().serialize(component);
        int lastFormatIndex = ((String)text).lastIndexOf("&");
        if (lastFormatIndex == -1 || lastFormatIndex == ((String)text).length() - 1) {
            return 15;
        }
        String last = ((String)text).substring(lastFormatIndex, lastFormatIndex + 2);
        return TeamColor.getColorId(last.charAt(1));
    }

    public void decode(ByteBuf byteBuf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void encode(ByteBuf byteBuf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        Optional<ScoreboardManager> optionalManager = this.plugin.getScoreboardManager();
        if (optionalManager.isEmpty()) {
            return;
        }
        optionalManager.get().getPacketAdapter(protocolVersion).encode(byteBuf, this, protocolVersion);
    }

    public boolean handle(MinecraftSessionHandler minecraftSessionHandler) {
        return false;
    }

    public Velocitab plugin() {
        return this.plugin;
    }

    public String teamName() {
        return this.teamName;
    }

    public UpdateMode mode() {
        return this.mode;
    }

    public Component displayName() {
        return this.displayName;
    }

    public List<FriendlyFlag> friendlyFlags() {
        return this.friendlyFlags;
    }

    public NametagVisibility nametagVisibility() {
        return this.nametagVisibility;
    }

    public CollisionRule collisionRule() {
        return this.collisionRule;
    }

    public int color() {
        return this.color;
    }

    public Component prefix() {
        return this.prefix;
    }

    public Component suffix() {
        return this.suffix;
    }

    public List<String> entities() {
        return this.entities;
    }

    public UpdateTeamsPacket teamName(String teamName) {
        this.teamName = teamName;
        return this;
    }

    public UpdateTeamsPacket mode(UpdateMode mode) {
        this.mode = mode;
        return this;
    }

    public UpdateTeamsPacket displayName(Component displayName) {
        this.displayName = displayName;
        return this;
    }

    public UpdateTeamsPacket friendlyFlags(List<FriendlyFlag> friendlyFlags) {
        this.friendlyFlags = friendlyFlags;
        return this;
    }

    public UpdateTeamsPacket nametagVisibility(NametagVisibility nametagVisibility) {
        this.nametagVisibility = nametagVisibility;
        return this;
    }

    public UpdateTeamsPacket collisionRule(CollisionRule collisionRule) {
        this.collisionRule = collisionRule;
        return this;
    }

    public UpdateTeamsPacket color(int color) {
        this.color = color;
        return this;
    }

    public UpdateTeamsPacket prefix(Component prefix) {
        this.prefix = prefix;
        return this;
    }

    public UpdateTeamsPacket suffix(Component suffix) {
        this.suffix = suffix;
        return this;
    }

    public UpdateTeamsPacket entities(List<String> entities) {
        this.entities = entities;
        return this;
    }

    public String toString() {
        return "UpdateTeamsPacket(plugin=" + this.plugin() + ", teamName=" + this.teamName() + ", mode=" + this.mode() + ", displayName=" + this.displayName() + ", friendlyFlags=" + this.friendlyFlags() + ", nametagVisibility=" + this.nametagVisibility() + ", collisionRule=" + this.collisionRule() + ", color=" + this.color() + ", prefix=" + this.prefix() + ", suffix=" + this.suffix() + ", entities=" + this.entities() + ")";
    }

    public UpdateTeamsPacket(Velocitab plugin, String teamName, UpdateMode mode, Component displayName, List<FriendlyFlag> friendlyFlags, NametagVisibility nametagVisibility, CollisionRule collisionRule, int color, Component prefix, Component suffix, List<String> entities) {
        this.plugin = plugin;
        this.teamName = teamName;
        this.mode = mode;
        this.displayName = displayName;
        this.friendlyFlags = friendlyFlags;
        this.nametagVisibility = nametagVisibility;
        this.collisionRule = collisionRule;
        this.color = color;
        this.prefix = prefix;
        this.suffix = suffix;
        this.entities = entities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateTeamsPacket)) {
            return false;
        }
        UpdateTeamsPacket other = (UpdateTeamsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.color() != other.color()) {
            return false;
        }
        Velocitab this$plugin = this.plugin();
        Velocitab other$plugin = other.plugin();
        if (this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin)) {
            return false;
        }
        String this$teamName = this.teamName();
        String other$teamName = other.teamName();
        if (this$teamName == null ? other$teamName != null : !this$teamName.equals(other$teamName)) {
            return false;
        }
        UpdateMode this$mode = this.mode();
        UpdateMode other$mode = other.mode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        Component this$displayName = this.displayName();
        Component other$displayName = other.displayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        List<FriendlyFlag> this$friendlyFlags = this.friendlyFlags();
        List<FriendlyFlag> other$friendlyFlags = other.friendlyFlags();
        if (this$friendlyFlags == null ? other$friendlyFlags != null : !((Object)this$friendlyFlags).equals(other$friendlyFlags)) {
            return false;
        }
        NametagVisibility this$nametagVisibility = this.nametagVisibility();
        NametagVisibility other$nametagVisibility = other.nametagVisibility();
        if (this$nametagVisibility == null ? other$nametagVisibility != null : !((Object)((Object)this$nametagVisibility)).equals((Object)other$nametagVisibility)) {
            return false;
        }
        CollisionRule this$collisionRule = this.collisionRule();
        CollisionRule other$collisionRule = other.collisionRule();
        if (this$collisionRule == null ? other$collisionRule != null : !((Object)((Object)this$collisionRule)).equals((Object)other$collisionRule)) {
            return false;
        }
        Component this$prefix = this.prefix();
        Component other$prefix = other.prefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Component this$suffix = this.suffix();
        Component other$suffix = other.suffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        List<String> this$entities = this.entities();
        List<String> other$entities = other.entities();
        return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateTeamsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.color();
        Velocitab $plugin = this.plugin();
        result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
        String $teamName = this.teamName();
        result = result * 59 + ($teamName == null ? 43 : $teamName.hashCode());
        UpdateMode $mode = this.mode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        Component $displayName = this.displayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        List<FriendlyFlag> $friendlyFlags = this.friendlyFlags();
        result = result * 59 + ($friendlyFlags == null ? 43 : ((Object)$friendlyFlags).hashCode());
        NametagVisibility $nametagVisibility = this.nametagVisibility();
        result = result * 59 + ($nametagVisibility == null ? 43 : ((Object)((Object)$nametagVisibility)).hashCode());
        CollisionRule $collisionRule = this.collisionRule();
        result = result * 59 + ($collisionRule == null ? 43 : ((Object)((Object)$collisionRule)).hashCode());
        Component $prefix = this.prefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Component $suffix = this.suffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        List<String> $entities = this.entities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        return result;
    }

    public static enum UpdateMode {
        CREATE_TEAM(0),
        REMOVE_TEAM(1),
        UPDATE_INFO(2),
        ADD_PLAYERS(3),
        REMOVE_PLAYERS(4);

        private final byte id;

        private UpdateMode(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        @Nullable
        public static UpdateMode byId(byte id) {
            return Arrays.stream(UpdateMode.values()).filter(mode -> mode.id == id).findFirst().orElse(null);
        }
    }

    public static enum FriendlyFlag {
        CAN_HURT_FRIENDLY(1),
        CAN_HURT_FRIENDLY_FIRE(2);

        private final int id;

        private FriendlyFlag(int id) {
            this.id = id;
        }

        @NotNull
        public static List<FriendlyFlag> fromBitMask(int bitMask) {
            return Arrays.stream(FriendlyFlag.values()).filter(flag -> (bitMask & flag.id) != 0).collect(Collectors.toList());
        }

        public static int toBitMask(@NotNull List<FriendlyFlag> friendlyFlags) {
            int bitMask = 0;
            for (FriendlyFlag friendlyFlag : friendlyFlags) {
                bitMask |= friendlyFlag.id;
            }
            return bitMask;
        }
    }

    public static enum NametagVisibility {
        ALWAYS("always"),
        NEVER("never"),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam");

        private final String id;

        private NametagVisibility(String id) {
            this.id = id;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public static NametagVisibility byId(@Nullable String id) {
            return id == null ? ALWAYS : Arrays.stream(NametagVisibility.values()).filter(visibility -> visibility.id.equals(id)).findFirst().orElse(ALWAYS);
        }
    }

    public static enum CollisionRule {
        ALWAYS("always"),
        NEVER("never"),
        PUSH_OTHER_TEAMS("pushOtherTeams"),
        PUSH_OWN_TEAM("pushOwnTeam");

        private final String id;

        private CollisionRule(String id) {
            this.id = id;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public static CollisionRule byId(@Nullable String id) {
            return id == null ? ALWAYS : Arrays.stream(CollisionRule.values()).filter(rule -> rule.id.equals(id)).findFirst().orElse(ALWAYS);
        }
    }

    public static enum TeamColor {
        BLACK('0', 0),
        DARK_BLUE('1', 1),
        DARK_GREEN('2', 2),
        DARK_AQUA('3', 3),
        DARK_RED('4', 4),
        DARK_PURPLE('5', 5),
        GOLD('6', 6),
        GRAY('7', 7),
        DARK_GRAY('8', 8),
        BLUE('9', 9),
        GREEN('a', 10),
        AQUA('b', 11),
        RED('c', 12),
        LIGHT_PURPLE('d', 13),
        YELLOW('e', 14),
        WHITE('f', 15),
        OBFUSCATED('k', 16),
        BOLD('f', 17),
        STRIKETHROUGH('f', 18),
        UNDERLINED('f', 19),
        ITALIC('f', 20),
        RESET('r', 21);

        private final char colorChar;
        private final int id;

        private TeamColor(char colorChar, int id) {
            this.colorChar = colorChar;
            this.id = id;
        }

        public static int getColorId(char var) {
            return Arrays.stream(TeamColor.values()).filter(color -> color.colorChar == var).map(c -> c.id).findFirst().orElse(15);
        }

        public char colorChar() {
            return this.colorChar;
        }
    }
}

