/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.commons.lang3.function.TriFunction;
import net.william278.velocitab.libraries.minedown.adventure.MineDown;
import net.william278.velocitab.player.TabPlayer;

public enum Formatter {
    MINEDOWN((text, player, plugin) -> new MineDown((String)text).toComponent(), text -> text.replace("__", "_\\_"), "MineDown", text -> new MineDown((String)text).toComponent()),
    MINIMESSAGE((text, player, plugin) -> plugin.getMiniPlaceholdersHook().map(hook -> hook.format((String)text, (Audience)player.getPlayer())).orElse(MiniMessage.miniMessage().deserialize(text)), text -> MiniMessage.miniMessage().escapeTags(text), "MiniMessage", text -> MiniMessage.miniMessage().deserialize(text)),
    LEGACY((text, player, plugin) -> LegacyComponentSerializer.legacyAmpersand().deserialize(text), Function.identity(), "Legacy Text", text -> LegacyComponentSerializer.legacyAmpersand().deserialize(text));

    private final String name;
    private final TriFunction<String, TabPlayer, Velocitab, Component> formatter;
    private final Function<String, String> escaper;
    private final Function<String, Component> emptyFormatter;

    private Formatter(@NotNull TriFunction<String, TabPlayer, Velocitab, Component> formatter, @NotNull Function<String, String> escaper, String name, Function<String, Component> emptyFormatter) {
        this.formatter = formatter;
        this.escaper = escaper;
        this.name = name;
        this.emptyFormatter = emptyFormatter;
    }

    @NotNull
    public Component format(@NotNull String text, @NotNull TabPlayer player, @NotNull Velocitab plugin) {
        return this.formatter.apply(text, player, plugin);
    }

    @NotNull
    public String formatLegacySymbols(@NotNull String text, @NotNull TabPlayer player, @NotNull Velocitab plugin) {
        return LegacyComponentSerializer.legacySection().serialize(this.format(text, player, plugin));
    }

    @NotNull
    public Component emptyFormat(@NotNull String text) {
        return this.emptyFormatter.apply(text);
    }

    @NotNull
    public String escape(@NotNull String text) {
        return this.escaper.apply(text);
    }

    @NotNull
    public String getName() {
        return this.name;
    }
}

