/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.tab;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.proxy.ProxyReloadEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.PlayerTabList;

public class TabListListener {
    private final Velocitab plugin;
    private final PlayerTabList tabList;

    public TabListListener(@NotNull Velocitab plugin, @NotNull PlayerTabList tabList) {
        this.plugin = plugin;
        this.tabList = tabList;
    }

    @Subscribe
    public void onKick(@NotNull KickedFromServerEvent event) {
        event.getPlayer().getTabList().clearAll();
        event.getPlayer().getTabList().clearHeaderAndFooter();
        if (event.getResult() instanceof KickedFromServerEvent.DisconnectPlayer || event.getResult() instanceof KickedFromServerEvent.RedirectPlayer) {
            this.tabList.removePlayer(event.getPlayer());
        }
    }

    @Subscribe
    public void onPlayerJoin(@NotNull ServerPostConnectEvent event) {
        boolean isDefault;
        Player joined = event.getPlayer();
        String serverName = joined.getCurrentServer().map(ServerConnection::getServerInfo).map(ServerInfo::getName).orElse("");
        Group group = this.tabList.getGroup(serverName);
        this.plugin.getScoreboardManager().ifPresent(manager -> manager.resetCache(joined, group));
        boolean bl = isDefault = !group.servers().contains(serverName);
        if (isDefault && !this.plugin.getSettings().isFallbackEnabled() && event.getPreviousServer() != null) {
            Optional<TabPlayer> tabPlayer = this.tabList.getTabPlayer(joined);
            if (tabPlayer.isEmpty()) {
                return;
            }
            Component header = tabPlayer.get().getLastHeader();
            Component footer = tabPlayer.get().getLastFooter();
            Component displayName = tabPlayer.get().getLastDisplayName();
            this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
                if (header.equals(event.getPlayer().getPlayerListHeader()) && footer.equals(event.getPlayer().getPlayerListFooter())) {
                    event.getPlayer().sendPlayerListHeaderAndFooter(header, footer);
                    event.getPlayer().getCurrentServer().ifPresent(serverConnection -> serverConnection.getServer().getPlayersConnected().forEach(player -> player.getTabList().getEntry(joined.getUniqueId()).ifPresent(entry -> {
                        if (entry.getDisplayNameComponent().isPresent() && ((Component)entry.getDisplayNameComponent().get()).equals(displayName)) {
                            entry.setDisplayName((Component)Component.text((String)joined.getUsername()));
                        }
                    })));
                }
            }).delay(500L, TimeUnit.MILLISECONDS).schedule();
            this.tabList.getPlayers().remove(event.getPlayer().getUniqueId());
            return;
        }
        this.tabList.joinPlayer(joined, group);
    }

    @Subscribe(order=PostOrder.LAST)
    public void onPlayerQuit(@NotNull DisconnectEvent event) {
        if (event.getLoginStatus() != DisconnectEvent.LoginStatus.SUCCESSFUL_LOGIN) {
            return;
        }
        UUID uuid = event.getPlayer().getUniqueId();
        this.tabList.removePlayer(event.getPlayer());
    }

    @Subscribe
    public void proxyReload(@NotNull ProxyReloadEvent event) {
        this.plugin.loadConfigs();
        this.tabList.reloadUpdate();
        this.plugin.log("Velocitab has been reloaded!");
    }
}

