/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.commons.text.StringEscapeUtils;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.Nametag;

public record Group(String name, List<String> headers, List<String> footers, String format, Nametag nametag, List<String> servers, List<String> sortingPlaceholders, boolean collisions, int headerFooterUpdateRate, int placeholderUpdateRate) {
    @NotNull
    public String getHeader(int index) {
        return this.headers.isEmpty() ? "" : StringEscapeUtils.unescapeJava(this.headers.get(Math.max(0, Math.min(index, this.headers.size() - 1))));
    }

    @NotNull
    public String getFooter(int index) {
        return this.footers.isEmpty() ? "" : StringEscapeUtils.unescapeJava(this.footers.get(Math.max(0, Math.min(index, this.footers.size() - 1))));
    }

    @NotNull
    public List<RegisteredServer> registeredServers(Velocitab plugin) {
        if (this.isDefault() && plugin.getSettings().isFallbackEnabled()) {
            return new ArrayList<RegisteredServer>(plugin.getServer().getAllServers());
        }
        return this.servers.stream().map(arg_0 -> ((ProxyServer)plugin.getServer()).getServer(arg_0)).filter(Optional::isPresent).map(Optional::get).toList();
    }

    public boolean isDefault() {
        return this.name.equals("default");
    }

    @NotNull
    public List<Player> getPlayers(Velocitab plugin) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (RegisteredServer server : this.registeredServers(plugin)) {
            players.addAll(server.getPlayersConnected());
        }
        return players;
    }

    @NotNull
    public List<TabPlayer> getTabPlayers(Velocitab plugin) {
        return plugin.getTabList().getPlayers().values().stream().filter(tabPlayer -> tabPlayer.getGroup().equals(this)).toList();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Group)) {
            return false;
        }
        Group group = (Group)obj;
        return this.name.equals(group.name);
    }
}

