/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.configlib;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.william278.velocitab.libraries.configlib.ConfigurationElement;
import net.william278.velocitab.libraries.configlib.ConfigurationException;
import net.william278.velocitab.libraries.configlib.ConfigurationProperties;
import net.william278.velocitab.libraries.configlib.ConfigurationSerializer;
import net.william278.velocitab.libraries.configlib.NameFormatter;
import net.william278.velocitab.libraries.configlib.RecordSerializer;
import net.william278.velocitab.libraries.configlib.Serializer;
import net.william278.velocitab.libraries.configlib.SerializerSelector;
import net.william278.velocitab.libraries.configlib.Validator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class TypeSerializer<T, E extends ConfigurationElement<?>>
implements Serializer<T, Map<?, ?>> {
    protected final Class<T> type;
    protected final ConfigurationProperties properties;
    protected final NameFormatter formatter;
    protected final Map<String, Serializer<?, ?>> serializers;

    protected TypeSerializer(Class<T> type, ConfigurationProperties properties) {
        this.type = Validator.requireNonNull(type, "type");
        this.properties = Validator.requireNonNull(properties, "configuration properties");
        this.formatter = properties.getNameFormatter();
        this.serializers = this.buildSerializerMap();
        this.requireSerializableElements();
    }

    static <T> TypeSerializer<T, ?> newSerializerFor(Class<T> type, ConfigurationProperties properties) {
        return type.isRecord() ? new RecordSerializer<T>(type, properties) : new ConfigurationSerializer<T>(type, properties);
    }

    Map<String, Serializer<?, ?>> buildSerializerMap() {
        SerializerSelector selector = new SerializerSelector(this.properties);
        try {
            return this.elements().stream().collect(Collectors.toMap(ConfigurationElement::name, selector::select));
        }
        catch (StackOverflowError error) {
            String msg = "Recursive type definitions are not supported.";
            throw new ConfigurationException(msg, error);
        }
    }

    @Override
    public final Map<?, ?> serialize(T configuration) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (ConfigurationElement element : this.elements()) {
            Object elementValue = element.value(configuration);
            if (elementValue == null && !this.properties.outputNulls()) continue;
            Object serializedValue = this.serialize(element, elementValue);
            String formattedName = this.formatter.format(element.name());
            result.put(formattedName, serializedValue);
        }
        return result;
    }

    protected final Object serialize(E element, Object value) {
        Serializer<?, ?> serializer = this.serializers.get(element.name());
        return value != null ? serializer.serialize(value) : null;
    }

    protected final Object deserialize(E element, Object value) {
        Object deserialized;
        Serializer<?, ?> serializer = this.serializers.get(element.name());
        try {
            deserialized = serializer.deserialize(value);
        }
        catch (ClassCastException e) {
            String msg = this.baseDeserializeExceptionMessage(element, value) + "\nThe type of the object to be deserialized does not match the type the deserializer expects.";
            throw new ConfigurationException(msg, e);
        }
        catch (RuntimeException e) {
            String msg = this.baseDeserializeExceptionMessage(element, value);
            throw new ConfigurationException(msg, e);
        }
        return deserialized;
    }

    protected abstract void requireSerializableElements();

    protected abstract String baseDeserializeExceptionMessage(E var1, Object var2);

    protected abstract List<E> elements();

    abstract T newDefaultInstance();
}

