/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.hook.Hook;
import net.william278.velocitab.hook.LuckPermsHook;
import net.william278.velocitab.hook.MiniPlaceholdersHook;
import net.william278.velocitab.hook.PAPIProxyBridgeHook;
import net.william278.velocitab.libraries.annotations.NotNull;

public interface HookProvider {
    public List<Hook> getHooks();

    public void setHooks(List<Hook> var1);

    public Velocitab getPlugin();

    default public void loadHooks() {
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        Hook.AVAILABLE.forEach(availableHook -> ((Optional)availableHook.apply(this.getPlugin())).ifPresent(hooks::add));
        this.setHooks(hooks);
    }

    private <H extends Hook> Optional<H> getHook(@NotNull Class<H> hookType) {
        return this.getHooks().stream().filter(hook -> hook.getClass().equals(hookType)).map(hookType::cast).findFirst();
    }

    default public Optional<LuckPermsHook> getLuckPermsHook() {
        return this.getHook(LuckPermsHook.class);
    }

    default public Optional<PAPIProxyBridgeHook> getPAPIProxyBridgeHook() {
        return this.getHook(PAPIProxyBridgeHook.class);
    }

    default public Optional<MiniPlaceholdersHook> getMiniPlaceholdersHook() {
        return this.getHook(MiniPlaceholdersHook.class);
    }
}

