/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.config;

import com.google.common.collect.Sets;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.libraries.commons.text.StringEscapeUtils;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.Nametag;
import org.slf4j.event.Level;

public record Group(String name, List<String> headers, List<String> footers, String format, Nametag nametag, Set<String> servers, List<String> sortingPlaceholders, boolean collisions, int headerFooterUpdateRate, int placeholderUpdateRate, boolean onlyListPlayersInSameServer) {
    @NotNull
    public String getHeader(int index) {
        return this.headers.isEmpty() ? "" : StringEscapeUtils.unescapeJava(this.headers.get(Math.max(0, Math.min(index, this.headers.size() - 1))));
    }

    @NotNull
    public String getFooter(int index) {
        return this.footers.isEmpty() ? "" : StringEscapeUtils.unescapeJava(this.footers.get(Math.max(0, Math.min(index, this.footers.size() - 1))));
    }

    @NotNull
    public Set<RegisteredServer> registeredServers(@NotNull Velocitab plugin) {
        return this.registeredServers(plugin, true);
    }

    @NotNull
    public Set<RegisteredServer> registeredServers(@NotNull Velocitab plugin, boolean includeAllPlayers) {
        if (includeAllPlayers && plugin.getSettings().isShowAllPlayersFromAllGroups() || this.isDefault(plugin) && plugin.getSettings().isFallbackEnabled()) {
            return Sets.newHashSet((Iterable)plugin.getServer().getAllServers());
        }
        return this.getRegexServers(plugin);
    }

    @NotNull
    private Set<RegisteredServer> getRegexServers(@NotNull Velocitab plugin) {
        HashSet totalServers = Sets.newHashSet();
        for (String server : this.servers) {
            try {
                Matcher matcher = Pattern.compile(server, 2).matcher("");
                plugin.getServer().getAllServers().stream().filter(registeredServer -> matcher.reset(registeredServer.getServerInfo().getName()).matches()).forEach(totalServers::add);
            }
            catch (PatternSyntaxException exception) {
                plugin.log(Level.WARN, "Invalid regex pattern " + server + " in group " + this.name, exception);
                plugin.getServer().getServer(server).ifPresent(totalServers::add);
            }
        }
        return totalServers;
    }

    public boolean isDefault(@NotNull Velocitab plugin) {
        return this.name.equals(plugin.getSettings().getFallbackGroup());
    }

    @NotNull
    public Set<Player> getPlayers(@NotNull Velocitab plugin) {
        HashSet players = Sets.newHashSet();
        for (RegisteredServer server : this.registeredServers(plugin)) {
            players.addAll(server.getPlayersConnected());
        }
        return players;
    }

    @NotNull
    public Set<Player> getPlayers(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer) {
        if (plugin.getSettings().isShowAllPlayersFromAllGroups()) {
            return Sets.newHashSet((Iterable)plugin.getServer().getAllPlayers());
        }
        if (this.onlyListPlayersInSameServer) {
            return tabPlayer.getPlayer().getCurrentServer().map(s -> Sets.newHashSet((Iterable)s.getServer().getPlayersConnected())).orElseGet(Sets::newHashSet);
        }
        return this.getPlayers(plugin);
    }

    @NotNull
    public Set<TabPlayer> getTabPlayers(@NotNull Velocitab plugin) {
        if (plugin.getSettings().isShowAllPlayersFromAllGroups()) {
            return Sets.newHashSet(plugin.getTabList().getPlayers().values());
        }
        return plugin.getTabList().getPlayers().values().stream().filter(tabPlayer -> tabPlayer.getGroup().equals(this)).collect(Collectors.toSet());
    }

    @NotNull
    public Set<TabPlayer> getTabPlayers(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer) {
        if (plugin.getSettings().isShowAllPlayersFromAllGroups()) {
            return Sets.newHashSet(plugin.getTabList().getPlayers().values());
        }
        if (this.onlyListPlayersInSameServer) {
            return plugin.getTabList().getPlayers().values().stream().filter(player -> player.getGroup().equals(this) && player.getServerName().equals(tabPlayer.getServerName())).collect(Collectors.toSet());
        }
        return this.getTabPlayers(plugin);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof Group)) {
            return false;
        }
        Group group = (Group)obj;
        return this.name.equals(group.name);
    }
}

