/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.packet.TeamsPacketAdapter;
import net.william278.velocitab.packet.UpdateTeamsPacket;

public class Protocol404Adapter
extends TeamsPacketAdapter {
    private final GsonComponentSerializer serializer;

    public Protocol404Adapter(@NotNull Velocitab plugin) {
        super(plugin, Set.of(ProtocolVersion.MINECRAFT_1_13_2, ProtocolVersion.MINECRAFT_1_14, ProtocolVersion.MINECRAFT_1_14_1, ProtocolVersion.MINECRAFT_1_14_2, ProtocolVersion.MINECRAFT_1_14_3, ProtocolVersion.MINECRAFT_1_14_4, ProtocolVersion.MINECRAFT_1_15, ProtocolVersion.MINECRAFT_1_15_1, ProtocolVersion.MINECRAFT_1_15_2));
        this.serializer = GsonComponentSerializer.colorDownsamplingGson();
    }

    public Protocol404Adapter(@NotNull Velocitab plugin, Set<ProtocolVersion> protocolVersions) {
        super(plugin, protocolVersions);
        this.serializer = null;
    }

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull UpdateTeamsPacket packet, @NotNull ProtocolVersion protocolVersion) {
        ProtocolUtils.writeString((ByteBuf)byteBuf, (CharSequence)packet.teamName());
        UpdateTeamsPacket.UpdateMode mode = packet.mode();
        byteBuf.writeByte((int)mode.id());
        if (mode == UpdateTeamsPacket.UpdateMode.REMOVE_TEAM) {
            return;
        }
        if (mode == UpdateTeamsPacket.UpdateMode.CREATE_TEAM || mode == UpdateTeamsPacket.UpdateMode.UPDATE_INFO) {
            this.writeComponent(byteBuf, packet.displayName());
            byteBuf.writeByte(UpdateTeamsPacket.FriendlyFlag.toBitMask(packet.friendlyFlags()));
            ProtocolUtils.writeString((ByteBuf)byteBuf, (CharSequence)packet.nametagVisibility().id());
            ProtocolUtils.writeString((ByteBuf)byteBuf, (CharSequence)packet.collisionRule().id());
            byteBuf.writeByte(packet.color());
            this.writeComponent(byteBuf, packet.prefix());
            this.writeComponent(byteBuf, packet.suffix());
        }
        if (mode == UpdateTeamsPacket.UpdateMode.CREATE_TEAM || mode == UpdateTeamsPacket.UpdateMode.ADD_PLAYERS || mode == UpdateTeamsPacket.UpdateMode.REMOVE_PLAYERS) {
            ArrayList entities = packet.entities();
            ProtocolUtils.writeVarInt((ByteBuf)byteBuf, (int)(entities != null ? entities.size() : 0));
            for (String entity : entities != null ? entities : new ArrayList()) {
                ProtocolUtils.writeString((ByteBuf)byteBuf, (CharSequence)entity);
            }
        }
    }

    @Override
    protected void writeComponent(ByteBuf buf, Component component) {
        ProtocolUtils.writeString((ByteBuf)buf, (CharSequence)((CharSequence)this.serializer.serialize(component)));
    }
}

