/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.packet;

import com.google.common.collect.Sets;
import com.velocitypowered.api.event.AwaitingEventExecutor;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.UpsertPlayerInfoPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.packet.PlayerChannelHandler;
import net.william278.velocitab.player.TabPlayer;

public class PacketEventManager {
    private static final String KEY = "velocitab";
    private static final String CITIZENS_PREFIX = "CIT";
    private final Velocitab plugin;
    private final Set<UUID> velocitabEntries;

    public PacketEventManager(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.velocitabEntries = Sets.newConcurrentHashSet();
        this.loadPlayers();
        this.loadListeners();
    }

    private void loadPlayers() {
        this.plugin.getServer().getAllPlayers().forEach(this::injectPlayer);
    }

    private void loadListeners() {
        this.plugin.getServer().getEventManager().register((Object)this.plugin, PostLoginEvent.class, (EventHandler)((AwaitingEventExecutor)postLoginEvent -> EventTask.withContinuation(continuation -> {
            this.injectPlayer(postLoginEvent.getPlayer());
            continuation.resume();
        })));
        this.plugin.getServer().getEventManager().register((Object)this.plugin, DisconnectEvent.class, (EventHandler)((AwaitingEventExecutor)disconnectEvent -> disconnectEvent.getLoginStatus() == DisconnectEvent.LoginStatus.CONFLICTING_LOGIN ? null : EventTask.async(() -> this.removePlayer(disconnectEvent.getPlayer()))));
    }

    public void injectPlayer(@NotNull Player player) {
        PlayerChannelHandler handler = new PlayerChannelHandler(this.plugin, player);
        ConnectedPlayer connectedPlayer = (ConnectedPlayer)player;
        this.removePlayer(player);
        connectedPlayer.getConnection().getChannel().pipeline().addBefore("handler", KEY, (ChannelHandler)handler);
    }

    public void removePlayer(@NotNull Player player) {
        ConnectedPlayer connectedPlayer = (ConnectedPlayer)player;
        Channel channel = connectedPlayer.getConnection().getChannel();
        if (channel.pipeline().get(KEY) != null) {
            channel.pipeline().remove(KEY);
        }
    }

    protected void handleEntry(@NotNull UpsertPlayerInfoPacket packet, @NotNull Player player) {
        List<TabPlayer> toUpdate = packet.getEntries().stream().filter(entry -> entry.getProfile() != null).filter(entry -> !entry.getProfile().getName().startsWith(CITIZENS_PREFIX)).filter(entry -> this.velocitabEntries.stream().noneMatch(uuid -> uuid.equals(entry.getProfile().getId()))).map(entry -> entry.getProfile().getId()).map(id -> this.plugin.getTabList().getTabPlayer((UUID)id)).filter(Optional::isPresent).map(Optional::get).filter(TabPlayer::isLoaded).toList();
        if (toUpdate.isEmpty()) {
            return;
        }
        toUpdate.forEach(tabPlayer -> packet.getEntries().stream().filter(entry -> entry.getProfileId().equals(tabPlayer.getPlayer().getUniqueId())).findFirst().ifPresent(entry -> entry.setDisplayName(new ComponentHolder(player.getProtocolVersion(), tabPlayer.getLastDisplayName()))));
    }

    public Set<UUID> getVelocitabEntries() {
        return this.velocitabEntries;
    }
}

