/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.packet.TeamsPacketAdapter;
import net.william278.velocitab.packet.UpdateTeamsPacket;

public class Protocol48Adapter
extends TeamsPacketAdapter {
    private final LegacyComponentSerializer serializer = LegacyComponentSerializer.legacySection();

    public Protocol48Adapter(@NotNull Velocitab plugin) {
        super(plugin, Set.of(ProtocolVersion.MINECRAFT_1_8, ProtocolVersion.MINECRAFT_1_12_2));
    }

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull UpdateTeamsPacket packet, @NotNull ProtocolVersion protocolVersion) {
        ProtocolUtils.writeString((ByteBuf)byteBuf, (CharSequence)this.shrinkString(packet.teamName()));
        UpdateTeamsPacket.UpdateMode mode = packet.mode();
        byteBuf.writeByte((int)mode.id());
        if (mode == UpdateTeamsPacket.UpdateMode.REMOVE_TEAM) {
            return;
        }
        if (mode == UpdateTeamsPacket.UpdateMode.CREATE_TEAM || mode == UpdateTeamsPacket.UpdateMode.UPDATE_INFO) {
            this.writeComponent(byteBuf, packet.displayName());
            this.writeComponent(byteBuf, packet.prefix());
            this.writeComponent(byteBuf, packet.suffix());
            byteBuf.writeByte(UpdateTeamsPacket.FriendlyFlag.toBitMask(packet.friendlyFlags()));
            ProtocolUtils.writeString((ByteBuf)byteBuf, (CharSequence)packet.nametagVisibility().id());
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_12_2) >= 0) {
                ProtocolUtils.writeString((ByteBuf)byteBuf, (CharSequence)packet.collisionRule().id());
            }
            byteBuf.writeByte(packet.color());
        }
        if (mode == UpdateTeamsPacket.UpdateMode.CREATE_TEAM || mode == UpdateTeamsPacket.UpdateMode.ADD_PLAYERS || mode == UpdateTeamsPacket.UpdateMode.REMOVE_PLAYERS) {
            ArrayList entities = packet.entities();
            ProtocolUtils.writeVarInt((ByteBuf)byteBuf, (int)(entities != null ? entities.size() : 0));
            for (String entity : entities != null ? entities : new ArrayList()) {
                ProtocolUtils.writeString((ByteBuf)byteBuf, (CharSequence)entity);
            }
        }
    }

    @NotNull
    private String shrinkString(@NotNull String string) {
        return string.substring(0, Math.min(string.length(), 16));
    }

    @Override
    protected void writeComponent(ByteBuf buf, Component component) {
        ProtocolUtils.writeString((ByteBuf)buf, (CharSequence)this.shrinkString(this.serializer.serialize(component)));
    }
}

