/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.providers;

import net.william278.velocitab.libraries.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public interface LoggerProvider {
    public Logger getLogger();

    default public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        switch (level) {
            case ERROR: {
                if (exceptions.length > 0) {
                    this.getLogger().error(message, exceptions[0]);
                    break;
                }
                this.getLogger().error(message);
                break;
            }
            case WARN: {
                if (exceptions.length > 0) {
                    this.getLogger().warn(message, exceptions[0]);
                    break;
                }
                this.getLogger().warn(message);
                break;
            }
            case INFO: {
                this.getLogger().info(message);
            }
        }
    }

    default public void log(@NotNull String message) {
        this.log(Level.INFO, message, new Throwable[0]);
    }
}

