/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.hook;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.hook.LuckPermsHook;
import net.william278.velocitab.hook.MiniPlaceholdersHook;
import net.william278.velocitab.hook.PAPIProxyBridgeHook;
import net.william278.velocitab.libraries.annotations.NotNull;
import org.slf4j.event.Level;

public abstract class Hook {
    public static final List<Function<Velocitab, Optional<Hook>>> AVAILABLE = List.of(plugin -> {
        if (Hook.isPluginAvailable(plugin, "luckperms")) {
            try {
                plugin.log("Successfully hooked into LuckPerms");
                return Optional.of(new LuckPermsHook((Velocitab)plugin));
            }
            catch (Throwable e) {
                plugin.log(Level.WARN, "LuckPerms hook was not loaded: " + e.getMessage(), e);
            }
        }
        return Optional.empty();
    }, plugin -> {
        if (Hook.isPluginAvailable(plugin, "papiproxybridge") && plugin.getSettings().isEnablePapiHook()) {
            try {
                plugin.log("Successfully hooked into PAPIProxyBridge");
                return Optional.of(new PAPIProxyBridgeHook((Velocitab)plugin));
            }
            catch (Throwable e) {
                plugin.log(Level.WARN, "PAPIProxyBridge hook was not loaded: " + e.getMessage(), e);
            }
        }
        return Optional.empty();
    }, plugin -> {
        if (Hook.isPluginAvailable(plugin, "miniplaceholders") && plugin.getSettings().isEnableMiniPlaceholdersHook()) {
            try {
                plugin.log("Successfully hooked into MiniPlaceholders");
                return Optional.of(new MiniPlaceholdersHook((Velocitab)plugin));
            }
            catch (Throwable e) {
                plugin.log(Level.WARN, "MiniPlaceholders hook was not loaded: " + e.getMessage(), e);
            }
        }
        return Optional.empty();
    });
    protected final Velocitab plugin;

    public Hook(@NotNull Velocitab plugin) {
        this.plugin = plugin;
    }

    private static boolean isPluginAvailable(@NotNull Velocitab plugin, @NotNull String id) {
        return plugin.getServer().getPluginManager().getPlugin(id).isPresent();
    }
}

