/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.sorting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Placeholder;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;

public class SortingManager {
    private final Velocitab plugin;
    private static final String DELIMITER = ":::";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^-?[0-9]\\d*(\\.\\d+)?$");

    public SortingManager(@NotNull Velocitab plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public CompletableFuture<String> getTeamName(@NotNull TabPlayer player) {
        if (!this.plugin.getSettings().isSortPlayers()) {
            return CompletableFuture.completedFuture("");
        }
        return ((CompletableFuture)((CompletableFuture)Placeholder.replace(String.join((CharSequence)DELIMITER, player.getGroup().sortingPlaceholders()), this.plugin, player).thenApply(s -> Arrays.asList(s.split(DELIMITER)))).thenApply(v -> v.stream().map(this::adaptValue).collect(Collectors.toList()))).thenApply(v -> this.handleList(player, (List<String>)v));
    }

    @NotNull
    private String handleList(@NotNull TabPlayer player, @NotNull List<String> values) {
        Object result = String.join((CharSequence)"", values);
        if (((String)result).length() > 12) {
            result = ((String)result).substring(0, 12);
        }
        result = (String)result + player.getPlayer().getUniqueId().toString().substring(0, 4);
        return result;
    }

    @NotNull
    private String adaptValue(@NotNull String value) {
        if (value.isEmpty()) {
            return "";
        }
        if (NUMBER_PATTERN.matcher(value).matches()) {
            double parsed = Double.parseDouble(value);
            parsed = Math.max(0.0, parsed);
            return this.compressNumber(5.3687091175E8 - parsed);
        }
        if (value.length() > 6) {
            return value.substring(0, 4);
        }
        return value;
    }

    @NotNull
    public String compressNumber(double number) {
        int wholePart;
        char decimalChar = (char)((number - (double)wholePart) * 65535.0);
        ArrayList charList = Lists.newArrayList();
        for (wholePart = (int)number; wholePart > 0; wholePart /= 65535) {
            char digit = (char)(wholePart % 65535);
            charList.add(0, Character.valueOf(digit));
        }
        if (charList.isEmpty()) {
            charList.add(Character.valueOf('\u0000'));
        }
        return charList.stream().map(String::valueOf).collect(Collectors.joining()) + decimalChar;
    }
}

